/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs;

import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import io.opentelemetry.proto.collector.logs.v1.LogsServiceGrpc;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.exceptions.BadRequestException;
import org.opensearch.dataprepper.exceptions.BufferWriteException;
import org.opensearch.dataprepper.exceptions.RequestCancelledException;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelLogsGrpcService
extends LogsServiceGrpc.LogsServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(OTelLogsGrpcService.class);
    public static final String REQUESTS_RECEIVED = "requestsReceived";
    public static final String SUCCESS_REQUESTS = "successRequests";
    public static final String PAYLOAD_SIZE = "payloadSize";
    public static final String REQUEST_PROCESS_DURATION = "requestProcessDuration";
    private final int bufferWriteTimeoutInMillis;
    private final OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder;
    private final Buffer<Record<Object>> buffer;
    private final Counter requestsReceivedCounter;
    private final Counter successRequestsCounter;
    private final DistributionSummary payloadSizeSummary;
    private final Timer requestProcessDuration;

    public OTelLogsGrpcService(int bufferWriteTimeoutInMillis, OTelProtoCodec.OTelProtoDecoder oTelProtoDecoder, Buffer<Record<Object>> buffer, PluginMetrics pluginMetrics) {
        this.bufferWriteTimeoutInMillis = bufferWriteTimeoutInMillis;
        this.buffer = buffer;
        this.oTelProtoDecoder = oTelProtoDecoder;
        this.requestsReceivedCounter = pluginMetrics.counter(REQUESTS_RECEIVED);
        this.successRequestsCounter = pluginMetrics.counter(SUCCESS_REQUESTS);
        this.payloadSizeSummary = pluginMetrics.summary(PAYLOAD_SIZE);
        this.requestProcessDuration = pluginMetrics.timer(REQUEST_PROCESS_DURATION);
    }

    public void export(ExportLogsServiceRequest request, StreamObserver<ExportLogsServiceResponse> responseObserver) {
        this.requestsReceivedCounter.increment();
        this.payloadSizeSummary.record((double)request.getSerializedSize());
        if (ServiceRequestContext.current().isTimedOut()) {
            return;
        }
        if (Context.current().isCancelled()) {
            throw new RequestCancelledException("Cancelled by client");
        }
        this.requestProcessDuration.record(() -> this.processRequest(request, responseObserver));
    }

    private void processRequest(ExportLogsServiceRequest request, StreamObserver<ExportLogsServiceResponse> responseObserver) {
        List logs;
        try {
            logs = this.oTelProtoDecoder.parseExportLogsServiceRequest(request, Instant.now());
        }
        catch (Exception e) {
            LOG.error("Failed to parse the request {} due to:", (Object)request, (Object)e);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        List records = logs.stream().map(log -> new Record(log)).collect(Collectors.toList());
        try {
            if (this.buffer.isByteBuffer()) {
                this.buffer.writeBytes(request.toByteArray(), null, this.bufferWriteTimeoutInMillis);
            } else {
                this.buffer.writeAll(records, this.bufferWriteTimeoutInMillis);
            }
        }
        catch (Exception e) {
            if (ServiceRequestContext.current().isTimedOut()) {
                LOG.warn("Exception writing to buffer but request already timed out.", (Throwable)e);
                return;
            }
            LOG.error("Failed to write the request of size {} due to:", (Object)request.toString().length(), (Object)e);
            throw new BufferWriteException(e.getMessage(), (Throwable)e);
        }
        if (ServiceRequestContext.current().isTimedOut()) {
            LOG.warn("Buffer write completed successfully but request already timed out.");
            return;
        }
        this.successRequestsCounter.increment();
        responseObserver.onNext((Object)ExportLogsServiceResponse.newBuilder().build());
        responseObserver.onCompleted();
    }
}

