/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365.configuration;

import java.time.Instant;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;

public class Office365ItemInfo
implements ItemInfo {
    private final String itemId;
    private final Instant eventTime;
    private final Map<String, Object> metadata;
    private final String partitionKey;
    private final Map<String, Object> keyAttributes;
    private final Instant lastModifiedAt;

    public String getItemId() {
        return this.itemId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getEventTime() {
        return this.eventTime;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getId() {
        return this.itemId;
    }

    public Map<String, Object> getKeyAttributes() {
        return this.keyAttributes;
    }

    public Instant getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    Office365ItemInfo(String itemId, Instant eventTime, Map<String, Object> metadata, String partitionKey, Map<String, Object> keyAttributes, Instant lastModifiedAt) {
        this.itemId = itemId;
        this.eventTime = eventTime;
        this.metadata = metadata;
        this.partitionKey = partitionKey;
        this.keyAttributes = keyAttributes;
        this.lastModifiedAt = lastModifiedAt;
    }

    public static Office365ItemInfoBuilder builder() {
        return new Office365ItemInfoBuilder();
    }

    public static class Office365ItemInfoBuilder {
        private String itemId;
        private Instant eventTime;
        private Map<String, Object> metadata;
        private String partitionKey;
        private Map<String, Object> keyAttributes;
        private Instant lastModifiedAt;

        Office365ItemInfoBuilder() {
        }

        public Office365ItemInfoBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public Office365ItemInfoBuilder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Office365ItemInfoBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Office365ItemInfoBuilder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Office365ItemInfoBuilder keyAttributes(Map<String, Object> keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public Office365ItemInfoBuilder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public Office365ItemInfo build() {
            return new Office365ItemInfo(this.itemId, this.eventTime, this.metadata, this.partitionKey, this.keyAttributes, this.lastModifiedAt);
        }

        public String toString() {
            return "Office365ItemInfo.Office365ItemInfoBuilder(itemId=" + this.itemId + ", eventTime=" + String.valueOf(this.eventTime) + ", metadata=" + String.valueOf(this.metadata) + ", partitionKey=" + this.partitionKey + ", keyAttributes=" + String.valueOf(this.keyAttributes) + ", lastModifiedAt=" + String.valueOf(this.lastModifiedAt) + ")";
        }
    }
}

