/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.Duration;
import java.util.Set;
import javax.inject.Named;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.plugin.PluginConfigVariable;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.pipeline.parser.ByteCountDeserializer;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDeserializationProblemHandler;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDurationDeserializer;
import org.opensearch.dataprepper.pipeline.parser.EnumDeserializer;
import org.opensearch.dataprepper.pipeline.parser.EventKeyDeserializer;
import org.opensearch.dataprepper.plugin.DataPrepperScalarTypeDeserializer;
import org.opensearch.dataprepper.plugin.VariableExpander;
import org.springframework.context.annotation.Bean;

@Named
public class ObjectMapperConfiguration {
    static final Set<Class> TRANSLATE_VALUE_SUPPORTED_JAVA_TYPES = Set.of(String.class, Number.class, Long.class, Short.class, Integer.class, Double.class, Float.class, Boolean.class, Character.class, PluginConfigVariable.class);

    @Bean(name={"extensionPluginConfigObjectMapper"})
    ObjectMapper extensionPluginConfigObjectMapper(DataPrepperDeserializationProblemHandler dataPrepperDeserializationProblemHandler) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Duration.class, (JsonDeserializer)new DataPrepperDurationDeserializer());
        simpleModule.addDeserializer(Enum.class, (JsonDeserializer)new EnumDeserializer());
        simpleModule.addDeserializer(ByteCount.class, (JsonDeserializer)new ByteCountDeserializer());
        return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)simpleModule).addHandler((DeserializationProblemHandler)dataPrepperDeserializationProblemHandler);
    }

    @Bean(name={"pluginConfigObjectMapper"})
    ObjectMapper pluginConfigObjectMapper(VariableExpander variableExpander, EventKeyFactory eventKeyFactory, DataPrepperDeserializationProblemHandler dataPrepperDeserializationProblemHandler) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Duration.class, (JsonDeserializer)new DataPrepperDurationDeserializer());
        simpleModule.addDeserializer(ByteCount.class, (JsonDeserializer)new ByteCountDeserializer());
        simpleModule.addDeserializer(Enum.class, (JsonDeserializer)new EnumDeserializer());
        simpleModule.addDeserializer(EventKey.class, (JsonDeserializer)new EventKeyDeserializer(eventKeyFactory));
        TRANSLATE_VALUE_SUPPORTED_JAVA_TYPES.stream().forEach(clazz -> simpleModule.addDeserializer(clazz, new DataPrepperScalarTypeDeserializer(variableExpander, clazz)));
        return new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)simpleModule).addHandler((DeserializationProblemHandler)dataPrepperDeserializationProblemHandler);
    }
}

