/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.plugin.DataPrepperExtensionPoints;
import org.opensearch.dataprepper.plugin.ExtensionLoader;

@Named(value="extensionsApplier")
class ExtensionsApplier {
    private final DataPrepperExtensionPoints dataPrepperExtensionPoints;
    private final ExtensionLoader extensionLoader;
    private List<? extends ExtensionPlugin> loadedExtensionPlugins = Collections.emptyList();

    @Inject
    ExtensionsApplier(DataPrepperExtensionPoints dataPrepperExtensionPoints, ExtensionLoader extensionLoader) {
        this.dataPrepperExtensionPoints = dataPrepperExtensionPoints;
        this.extensionLoader = extensionLoader;
    }

    @PostConstruct
    void applyExtensions() {
        this.loadedExtensionPlugins = this.extensionLoader.loadExtensions();
        for (ExtensionPlugin extensionPlugin : this.loadedExtensionPlugins) {
            extensionPlugin.apply((ExtensionPoints)this.dataPrepperExtensionPoints);
        }
    }

    @PreDestroy
    public void shutdownExtensions() {
        this.loadedExtensionPlugins.forEach(ExtensionPlugin::shutdown);
    }
}

