/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugin.PluginBeanFactoryProvider;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.support.GenericApplicationContext;

@Named
public class DataPrepperExtensionPoints
implements ExtensionPoints {
    private static final ExtensionProvider.Context EMPTY_CONTEXT = new EmptyContext();
    private final GenericApplicationContext sharedApplicationContext;
    private final GenericApplicationContext coreApplicationContext;

    @Inject
    public DataPrepperExtensionPoints(PluginBeanFactoryProvider pluginBeanFactoryProvider) {
        Objects.requireNonNull(pluginBeanFactoryProvider);
        Objects.requireNonNull(pluginBeanFactoryProvider.getCoreApplicationContext());
        Objects.requireNonNull(pluginBeanFactoryProvider.getSharedPluginApplicationContext());
        this.sharedApplicationContext = pluginBeanFactoryProvider.getSharedPluginApplicationContext();
        this.coreApplicationContext = pluginBeanFactoryProvider.getCoreApplicationContext();
    }

    public void addExtensionProvider(ExtensionProvider extensionProvider) {
        this.coreApplicationContext.registerBean(extensionProvider.supportedClass(), () -> extensionProvider.provideInstance(EMPTY_CONTEXT).orElse(null), new BeanDefinitionCustomizer[]{b -> b.setScope("prototype")});
        this.sharedApplicationContext.registerBean(extensionProvider.supportedClass(), () -> extensionProvider.provideInstance(EMPTY_CONTEXT), new BeanDefinitionCustomizer[]{b -> b.setScope("prototype")});
    }

    private static class EmptyContext
    implements ExtensionProvider.Context {
        private EmptyContext() {
        }
    }
}

