/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.discovery;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.DynamicEndpointGroup;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.CommonPools;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.metricpublisher.MicrometerMetricPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClientBuilder;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary;

class AwsCloudMapPeerListProvider
implements PeerListProvider,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsCloudMapPeerListProvider.class);
    private static final int ONE_SECOND = 1000;
    private static final int TWENTY_SECONDS = 32000;
    private static final double TWENTY_PERCENT = 0.2;
    private static final String INSTANCE_IP4_ATTRIBUTE_NAME = "AWS_INSTANCE_IPV4";
    private final ServiceDiscoveryAsyncClient awsServiceDiscovery;
    private final String namespaceName;
    private final String serviceName;
    private final Map<String, String> queryParameters;
    private final AwsCloudMapDynamicEndpointGroup endpointGroup;
    private final Duration timeToRefresh;
    private final Backoff backoff;
    private final EventLoop eventLoop;
    private final String domainName;

    AwsCloudMapPeerListProvider(ServiceDiscoveryAsyncClient awsServiceDiscovery, String namespaceName, String serviceName, Map<String, String> queryParameters, Duration timeToRefresh, Backoff backoff, PluginMetrics pluginMetrics) {
        this.awsServiceDiscovery = Objects.requireNonNull(awsServiceDiscovery);
        this.namespaceName = Objects.requireNonNull(namespaceName);
        this.serviceName = Objects.requireNonNull(serviceName);
        this.queryParameters = Objects.requireNonNull(queryParameters);
        this.timeToRefresh = timeToRefresh;
        this.backoff = Objects.requireNonNull(backoff);
        if (timeToRefresh.isNegative() || timeToRefresh.isZero()) {
            throw new IllegalArgumentException("timeToRefreshSeconds must be positive. Actual: " + String.valueOf(timeToRefresh));
        }
        this.eventLoop = CommonPools.workerGroup().next();
        LOG.info("Using AWS CloudMap for Peer Forwarding. namespace='{}', serviceName='{}'", (Object)namespaceName, (Object)serviceName);
        this.endpointGroup = new AwsCloudMapDynamicEndpointGroup();
        this.domainName = serviceName + "." + namespaceName;
        pluginMetrics.gauge("peerEndpoints", (Object)this.endpointGroup, group -> group.endpoints().size());
    }

    static AwsCloudMapPeerListProvider createPeerListProvider(PeerForwarderConfiguration peerForwarderConfiguration, PluginMetrics pluginMetrics) {
        String awsRegion = peerForwarderConfiguration.getAwsRegion();
        Objects.requireNonNull(awsRegion, "Missing aws_region configuration value");
        String namespace = peerForwarderConfiguration.getAwsCloudMapNamespaceName();
        Objects.requireNonNull(namespace, "Missing aws_cloud_map_namespace_name configuration value");
        String serviceName = peerForwarderConfiguration.getAwsCloudMapServiceName();
        Objects.requireNonNull(serviceName, "Missing aws_cloud_map_service_name configuration value");
        Map<String, String> queryParameters = peerForwarderConfiguration.getAwsCloudMapQueryParameters();
        Backoff standardBackoff = Backoff.exponential((long)1000L, (long)32000L).withJitter(0.2);
        Duration timeToRefresh = Duration.ofSeconds(20L);
        PluginMetrics awsSdkMetrics = PluginMetrics.fromNames((String)"sdk", (String)"aws");
        ServiceDiscoveryAsyncClient serviceDiscoveryAsyncClient = (ServiceDiscoveryAsyncClient)((ServiceDiscoveryAsyncClientBuilder)((ServiceDiscoveryAsyncClientBuilder)((ServiceDiscoveryAsyncClientBuilder)ServiceDiscoveryAsyncClient.builder().region(Region.of((String)awsRegion))).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(metricPublisher -> metricPublisher.addMetricPublisher((MetricPublisher)new MicrometerMetricPublisher(awsSdkMetrics)))).build();
        return new AwsCloudMapPeerListProvider(serviceDiscoveryAsyncClient, namespace, serviceName, queryParameters, timeToRefresh, standardBackoff, pluginMetrics);
    }

    @Override
    public List<String> getPeerList() {
        return this.endpointGroup.endpoints().stream().map(Endpoint::ipAddr).collect(Collectors.toList());
    }

    public void addListener(Consumer<? super List<Endpoint>> listener) {
        this.endpointGroup.addListener(listener);
    }

    public void removeListener(Consumer<?> listener) {
        this.endpointGroup.removeListener(listener);
    }

    @Override
    public void close() {
        this.endpointGroup.close();
    }

    private class AwsCloudMapDynamicEndpointGroup
    extends DynamicEndpointGroup {
        private int failedAttemptCount = 0;
        private volatile ScheduledFuture<?> scheduledDiscovery;

        private AwsCloudMapDynamicEndpointGroup() {
            AwsCloudMapPeerListProvider.this.eventLoop.execute(this::discoverInstances);
        }

        private void discoverInstances() {
            if (this.isClosing()) {
                return;
            }
            DiscoverInstancesRequest discoverInstancesRequest = (DiscoverInstancesRequest)DiscoverInstancesRequest.builder().namespaceName(AwsCloudMapPeerListProvider.this.namespaceName).serviceName(AwsCloudMapPeerListProvider.this.serviceName).queryParameters(AwsCloudMapPeerListProvider.this.queryParameters).build();
            LOG.debug("Discovering instances.");
            AwsCloudMapPeerListProvider.this.awsServiceDiscovery.discoverInstances(discoverInstancesRequest).whenComplete((discoverInstancesResponse, throwable) -> {
                if (discoverInstancesResponse != null) {
                    try {
                        this.failedAttemptCount = 0;
                        this.updateEndpointsWithDiscoveredInstances((DiscoverInstancesResponse)discoverInstancesResponse);
                    }
                    catch (Exception ex) {
                        LOG.warn("Failed to update endpoints.", (Throwable)ex);
                    }
                    finally {
                        this.scheduledDiscovery = AwsCloudMapPeerListProvider.this.eventLoop.schedule(this::discoverInstances, AwsCloudMapPeerListProvider.this.timeToRefresh.toMillis(), TimeUnit.MILLISECONDS);
                    }
                }
                if (throwable != null) {
                    ++this.failedAttemptCount;
                    long delayMillis = AwsCloudMapPeerListProvider.this.backoff.nextDelayMillis(this.failedAttemptCount);
                    LOG.error("Failed to discover instances for: namespace='{}', serviceName='{}'. Will retry in {} ms.", new Object[]{AwsCloudMapPeerListProvider.this.namespaceName, AwsCloudMapPeerListProvider.this.serviceName, delayMillis, throwable});
                    this.scheduledDiscovery = AwsCloudMapPeerListProvider.this.eventLoop.schedule(this::discoverInstances, delayMillis, TimeUnit.MILLISECONDS);
                }
            });
        }

        private void updateEndpointsWithDiscoveredInstances(DiscoverInstancesResponse discoverInstancesResponse) {
            List instances = discoverInstancesResponse.instances();
            LOG.debug("Discovered {} instances.", (Object)instances.size());
            List endpoints = instances.stream().map(HttpInstanceSummary::attributes).map(attributes -> (String)attributes.get(AwsCloudMapPeerListProvider.INSTANCE_IP4_ATTRIBUTE_NAME)).map(ip -> Endpoint.of((String)AwsCloudMapPeerListProvider.this.domainName).withIpAddr(ip)).collect(Collectors.toList());
            this.setEndpoints(endpoints);
        }

        protected void doCloseAsync(CompletableFuture<?> future) {
            ScheduledFuture<?> scheduledDiscovery = this.scheduledDiscovery;
            if (scheduledDiscovery != null) {
                scheduledDiscovery.cancel(true);
            }
            future.complete(null);
        }
    }
}

