/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.opensearch.dataprepper.core.parser.config.FileStructurePathProvider;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.pipeline.parser.ByteCountDeserializer;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDurationDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataPrepperAppConfiguration {
    @Bean
    public DataPrepperConfiguration dataPrepperConfiguration(FileStructurePathProvider fileStructurePathProvider, ObjectMapper objectMapper) {
        String dataPrepperConfigFileLocation = fileStructurePathProvider.getDataPrepperConfigFileLocation();
        if (dataPrepperConfigFileLocation != null) {
            File configurationFile = new File(dataPrepperConfigFileLocation);
            try {
                SimpleModule simpleModule = new SimpleModule().addDeserializer(Duration.class, (JsonDeserializer)new DataPrepperDurationDeserializer()).addDeserializer(ByteCount.class, (JsonDeserializer)new ByteCountDeserializer());
                objectMapper.registerModule((Module)simpleModule);
                return (DataPrepperConfiguration)objectMapper.readValue(configurationFile, DataPrepperConfiguration.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid DataPrepper configuration file.", e);
            }
        }
        return new DataPrepperConfiguration();
    }

    @Bean
    public PluginModel authentication(DataPrepperConfiguration dataPrepperConfiguration) {
        return dataPrepperConfiguration.getAuthentication();
    }
}

