/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.breaker;

import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.core.breaker.InnerCircuitBreaker;
import org.opensearch.dataprepper.model.breaker.CircuitBreaker;

public class CircuitBreakerManager {
    private final CircuitBreaker globalCircuitBreaker;

    CircuitBreakerManager(List<InnerCircuitBreaker> circuitBreakers) {
        this.globalCircuitBreaker = circuitBreakers.isEmpty() ? null : new GlobalCircuitBreaker(circuitBreakers);
    }

    public Optional<CircuitBreaker> getGlobalCircuitBreaker() {
        return Optional.ofNullable(this.globalCircuitBreaker);
    }

    private static class GlobalCircuitBreaker
    implements CircuitBreaker {
        private final List<InnerCircuitBreaker> circuitBreakers;

        public GlobalCircuitBreaker(List<InnerCircuitBreaker> circuitBreakers) {
            this.circuitBreakers = circuitBreakers;
        }

        public boolean isOpen() {
            return this.circuitBreakers.stream().anyMatch(CircuitBreaker::isOpen);
        }
    }
}

