/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessorConfig;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.BedrockBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.MLBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.SageMakerBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.configuration.ServiceName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLBatchJobCreatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MLProcessor.class);
    private static final Map<ServiceName, MLBatchJobCreator> jobCreators = new ConcurrentHashMap<ServiceName, MLBatchJobCreator>();

    public static MLBatchJobCreator getJobCreator(ServiceName serviceName, MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, PluginMetrics pluginMetrics) {
        if (serviceName == null) {
            throw new IllegalArgumentException("ServiceName cannot be null");
        }
        return jobCreators.computeIfAbsent(serviceName, key -> MLBatchJobCreatorFactory.createJobCreator(key, mlProcessorConfig, awsCredentialsSupplier, pluginMetrics));
    }

    private static MLBatchJobCreator createJobCreator(ServiceName serviceName, MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, PluginMetrics pluginMetrics) {
        switch (serviceName) {
            case SAGEMAKER: {
                return new SageMakerBatchJobCreator(mlProcessorConfig, awsCredentialsSupplier, pluginMetrics);
            }
            case BEDROCK: {
                return new BedrockBatchJobCreator(mlProcessorConfig, awsCredentialsSupplier, pluginMetrics);
            }
        }
        LOG.warn("Unsupported service name provided: {}", (Object)serviceName);
        throw new IllegalArgumentException("Unsupported ServiceName: " + String.valueOf((Object)serviceName) + ". Expected values: SAGEMAKER, BEDROCK.");
    }
}

