/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.util.List;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessorConfig;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.MLBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.util.MlCommonRequester;
import software.amazon.awssdk.auth.signer.Aws4Signer;

public abstract class AbstractBatchJobCreator
implements MLBatchJobCreator {
    public static final String NUMBER_OF_SUCCESSFUL_BATCH_JOBS_CREATION = "batchJobsCreationSucceeded";
    public static final String NUMBER_OF_FAILED_BATCH_JOBS_CREATION = "batchJobsCreationFailed";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final MLProcessorConfig mlProcessorConfig;
    protected final AwsCredentialsSupplier awsCredentialsSupplier;
    protected final Counter numberOfBatchJobsSuccessCounter;
    protected final Counter numberOfBatchJobsFailedCounter;
    protected final List<String> tagsOnFailure;
    protected final MlCommonRequester mlCommonRequester;
    private static final Aws4Signer signer = Aws4Signer.create();

    public AbstractBatchJobCreator(MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, PluginMetrics pluginMetrics) {
        this.mlProcessorConfig = mlProcessorConfig;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.numberOfBatchJobsSuccessCounter = pluginMetrics.counter(NUMBER_OF_SUCCESSFUL_BATCH_JOBS_CREATION);
        this.numberOfBatchJobsFailedCounter = pluginMetrics.counter(NUMBER_OF_FAILED_BATCH_JOBS_CREATION);
        this.tagsOnFailure = mlProcessorConfig.getTagsOnFailure();
        this.mlCommonRequester = new MlCommonRequester(signer, mlProcessorConfig, awsCredentialsSupplier);
    }

    public void incrementSuccessCounter() {
        this.numberOfBatchJobsSuccessCounter.increment();
    }

    public void incrementFailureCounter() {
        this.numberOfBatchJobsFailedCounter.increment();
    }

    @Override
    public abstract void createMLBatchJob(List<Record<Event>> var1, List<Record<Event>> var2);

    protected List<Record<Event>> addFailureTags(List<Record<Event>> records) {
        if (this.tagsOnFailure == null || this.tagsOnFailure.isEmpty()) {
            return records;
        }
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            EventMetadata metadata = event.getMetadata();
            if (metadata != null) {
                metadata.addTags(this.tagsOnFailure);
                continue;
            }
            MLProcessor.LOG.warn("Event metadata is null, cannot add failure tags.");
        }
        return records;
    }
}

