/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.ActionResponse;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class GetAliasesResponse
extends ActionResponse {
    private final ImmutableOpenMap<String, List<AliasMetadata>> aliases;

    public GetAliasesResponse(ImmutableOpenMap<String, List<AliasMetadata>> aliases) {
        this.aliases = aliases;
    }

    public GetAliasesResponse(StreamInput in) throws IOException {
        super(in);
        this.aliases = in.readImmutableMap(StreamInput::readString, i -> i.readList(AliasMetadata::new));
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.aliases, StreamOutput::writeString, StreamOutput::writeList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAliasesResponse that = (GetAliasesResponse)o;
        return Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.aliases);
    }
}

