/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping.mutate;

import java.util.List;
import org.opensearch.dataprepper.logstash.mapping.mutate.AbstractConversion;

class SubstituteStringConversion
extends AbstractConversion<SubstituteStringConfig> {
    SubstituteStringConversion() {
    }

    public static String getLogstashName() {
        return "gsub";
    }

    @Override
    protected void addKvToEntries(String key, Object value) {
    }

    @Override
    protected void addListToEntries(List<String> list) {
        for (int i = 0; i < list.size(); i += 3) {
            String gsubSource = list.get(i);
            String gsubPatternToReplace = list.get(i + 1);
            String gsubStringToReplaceWith = list.get(i + 2);
            SubstituteStringConfig newConfig = new SubstituteStringConfig(gsubSource, gsubPatternToReplace, gsubStringToReplaceWith);
            this.entries.add(newConfig);
        }
    }

    @Override
    protected String getDataPrepperName() {
        return "substitute_string";
    }

    @Override
    protected String getMapKey() {
        return "entries";
    }

    public static class SubstituteStringConfig {
        public final String source;
        public final String from;
        public final String to;

        public SubstituteStringConfig(String source, String from, String to) {
            this.source = source;
            this.from = from;
            this.to = to;
        }
    }
}

