/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.logstash.exception.LogstashMappingException;
import org.opensearch.dataprepper.logstash.mapping.LogstashPluginMapper;
import org.opensearch.dataprepper.logstash.model.LogstashConfiguration;
import org.opensearch.dataprepper.logstash.model.LogstashPlugin;
import org.opensearch.dataprepper.logstash.model.LogstashPluginType;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.SinkModel;

public class LogstashMapper {
    public PipelineModel mapPipeline(LogstashConfiguration logstashConfiguration) {
        List<PluginModel> sourcePluginModels = this.mapPluginSection(logstashConfiguration, LogstashPluginType.INPUT);
        PluginModel sourcePlugin = null;
        if (sourcePluginModels.size() != 1) {
            throw new LogstashMappingException("Only logstash configurations with exactly 1 input plugin are supported");
        }
        sourcePlugin = sourcePluginModels.get(0);
        List<PluginModel> prepperPluginModels = this.mapPluginSection(logstashConfiguration, LogstashPluginType.FILTER);
        List<SinkModel> sinkPluginModels = this.mapSinkPluginSection(logstashConfiguration, LogstashPluginType.OUTPUT);
        if (sinkPluginModels.isEmpty()) {
            throw new LogstashMappingException("At least one logstash output plugin is required");
        }
        return new PipelineModel(sourcePlugin, null, prepperPluginModels, null, sinkPluginModels, null, null);
    }

    private List<SinkModel> mapSinkPluginSection(LogstashConfiguration logstashConfiguration, LogstashPluginType logstashPluginType) {
        return this.mapPluginSection(logstashConfiguration, logstashPluginType).stream().map(pluginModel -> SinkModel.builder((PluginModel)pluginModel).build()).collect(Collectors.toList());
    }

    private List<PluginModel> mapPluginSection(LogstashConfiguration logstashConfiguration, LogstashPluginType logstashPluginType) {
        LogstashPluginMapper pluginMapper = new LogstashPluginMapper();
        LinkedList<PluginModel> pluginModels = new LinkedList<PluginModel>();
        List<LogstashPlugin> logstashPluginList = logstashConfiguration.getPluginSection(logstashPluginType);
        if (logstashPluginList != null) {
            logstashPluginList.forEach(logstashPlugin -> pluginModels.addAll(pluginMapper.mapPlugin((LogstashPlugin)logstashPlugin)));
        }
        return pluginModels;
    }
}

