/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.UsageProfileDefinition;
import software.amazon.awssdk.services.glue.model.UsageProfileDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsageProfilesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListUsageProfilesResponse> {
    private static final SdkField<List<UsageProfileDefinition>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(ListUsageProfilesResponse.getter(ListUsageProfilesResponse::profiles)).setter(ListUsageProfilesResponse.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageProfileDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUsageProfilesResponse.getter(ListUsageProfilesResponse::nextToken)).setter(ListUsageProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsageProfilesResponse.memberNameToFieldInitializer();
    private final List<UsageProfileDefinition> profiles;
    private final String nextToken;

    private ListUsageProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profiles = builder.profiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<UsageProfileDefinition> profiles() {
        return this.profiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageProfilesResponse)) {
            return false;
        }
        ListUsageProfilesResponse other = (ListUsageProfilesResponse)((Object)obj);
        return this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsageProfilesResponse").add("Profiles", this.hasProfiles() ? this.profiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Profiles", PROFILES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsageProfilesResponse, T> g) {
        return obj -> g.apply((ListUsageProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<UsageProfileDefinition> profiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageProfilesResponse model) {
            super(model);
            this.profiles(model.profiles);
            this.nextToken(model.nextToken);
        }

        public final List<UsageProfileDefinition.Builder> getProfiles() {
            List<UsageProfileDefinition.Builder> result = UsageProfileDefinitionListCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<UsageProfileDefinition.BuilderImpl> profiles) {
            this.profiles = UsageProfileDefinitionListCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<UsageProfileDefinition> profiles) {
            this.profiles = UsageProfileDefinitionListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(UsageProfileDefinition ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<UsageProfileDefinition.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (UsageProfileDefinition)((UsageProfileDefinition.Builder)UsageProfileDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUsageProfilesResponse build() {
            return new ListUsageProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsageProfilesResponse> {
        public Builder profiles(Collection<UsageProfileDefinition> var1);

        public Builder profiles(UsageProfileDefinition ... var1);

        public Builder profiles(Consumer<UsageProfileDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

