/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.common.serialization;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.kafka.common.serialization.Deserializer;
import org.opensearch.dataprepper.plugins.kafka.common.serialization.EncryptionContext;

class DecryptionDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> innerDeserializer;
    private final Cipher cipher;
    private final EncryptionContext encryptionContext;

    DecryptionDeserializer(Deserializer<T> innerDeserializer, EncryptionContext encryptionContext) throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        this.innerDeserializer = innerDeserializer;
        this.cipher = encryptionContext.createDecryptionCipher();
        this.encryptionContext = encryptionContext;
    }

    public T deserialize(String topic, byte[] data) {
        byte[] unencryptedBytes;
        try {
            unencryptedBytes = this.cipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        return (T)this.innerDeserializer.deserialize(topic, unencryptedBytes);
    }

    EncryptionContext getEncryptionContext() {
        return this.encryptionContext;
    }

    Deserializer<T> getInnerDeserializer() {
        return this.innerDeserializer;
    }
}

