/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.event;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.Objects;
import org.opensearch.dataprepper.core.event.EventConfiguration;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingEventKeyFactory
implements EventKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(CachingEventKeyFactory.class);
    private final EventKeyFactory delegateEventKeyFactory;
    private final Cache<CacheKey, EventKey> cache;

    CachingEventKeyFactory(EventKeyFactory delegateEventKeyFactory, EventConfiguration eventConfiguration) {
        Objects.requireNonNull(delegateEventKeyFactory);
        Objects.requireNonNull(eventConfiguration);
        log.debug("Configured to cache a maximum of {} event keys.", (Object)eventConfiguration.getMaximumCachedKeys());
        this.delegateEventKeyFactory = delegateEventKeyFactory;
        this.cache = Caffeine.newBuilder().maximumSize((long)eventConfiguration.getMaximumCachedKeys().intValue()).build();
    }

    public EventKey createEventKey(String key, EventKeyFactory.EventAction ... forActions) {
        return this.getOrCreateEventKey(new CacheKey(key, forActions));
    }

    private EventKey getOrCreateEventKey(CacheKey cacheKey) {
        return this.cache.asMap().computeIfAbsent(cacheKey, key -> this.delegateEventKeyFactory.createEventKey(key.key, key.eventActions));
    }

    private static class CacheKey {
        private final String key;
        private final EventKeyFactory.EventAction[] eventActions;

        private CacheKey(String key, EventKeyFactory.EventAction[] eventActions) {
            this.key = key;
            this.eventActions = eventActions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.key, cacheKey.key) && Arrays.equals(this.eventActions, cacheKey.eventActions);
        }

        public int hashCode() {
            int result = Objects.hash(this.key);
            result = 31 * result + Arrays.hashCode(this.eventActions);
            return result;
        }
    }
}

