/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class SqsThresholdConfig {
    public static final int DEFAULT_MESSAGES_PER_EVENT = 25;
    public static final ByteCount DEFAULT_MAX_MESSAGE_SIZE = ByteCount.parse((String)"256kb");
    public static final long DEFAULT_FLUSH_INTERVAL_TIME = 30L;
    @JsonProperty(value="max_events_per_message", defaultValue="25")
    @Min(value=1L)
    @Max(value=1000L)
    private @Min(value=1L) @Max(value=1000L) int maxEventsPerMessage = 25;
    @JsonProperty(value="max_message_size")
    private ByteCount maxMessageSize = DEFAULT_MAX_MESSAGE_SIZE;
    @JsonProperty(value="flush_interval")
    @DurationMin(seconds=60L)
    @DurationMax(seconds=3600L)
    private @DurationMin(seconds=60L) @DurationMax(seconds=3600L) Duration flushInterval = Duration.ofSeconds(30L);

    public long getMaxMessageSizeBytes() {
        return this.maxMessageSize.getBytes();
    }

    public int getMaxEventsPerMessage() {
        return this.maxEventsPerMessage;
    }

    public long getFlushInterval() {
        return this.flushInterval.getSeconds();
    }
}

