/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import org.opensearch.dataprepper.aws.api.AwsConfig;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsThresholdConfig;

public class SqsSinkConfig {
    public static int DEFAULT_MAX_RETRIES = 3;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="queue_url")
    @NotNull
    private String queueUrl;
    @JsonProperty(value="codec")
    private PluginModel codec;
    @JsonProperty(value="threshold")
    private SqsThresholdConfig thresholdConfig = new SqsThresholdConfig();
    @JsonProperty(value="max_retries")
    private int maxRetries = DEFAULT_MAX_RETRIES;
    @JsonProperty(value="group_id")
    private String groupId;
    @JsonProperty(value="deduplication_id")
    private String deDuplicationId;
    @JsonProperty(value="dlq")
    private PluginModel dlq;

    @AssertTrue(message="FIFO queues wth dynamic group id or dynamic deduplication id and more than one events per message is not valid OR standard queues do not support groupId or deduplication configuration")
    @AssertTrue(message="FIFO queues wth dynamic group id or dynamic deduplication id and more than one events per message is not valid OR standard queues do not support groupId or deduplication configuration") boolean isValidConfig() {
        boolean isDynamicQueueUrl;
        String deDupId = this.getDeDuplicationId();
        String groupId = this.getGroupId();
        String queueUrl = this.getQueueUrl();
        boolean isDynamicDeDupId = deDupId != null && deDupId.contains("${");
        boolean isDynamicGroupId = groupId != null && groupId.contains("${");
        boolean bl = isDynamicQueueUrl = queueUrl != null && queueUrl.contains("${");
        if (isDynamicQueueUrl) {
            return true;
        }
        if (this.getQueueUrl().endsWith(".fifo")) {
            return !isDynamicGroupId && !isDynamicDeDupId || this.thresholdConfig.getMaxEventsPerMessage() <= 1;
        }
        return groupId == null && deDupId == null;
    }

    @AssertTrue(message="ndjson codec (default codec) doesn't support max events per message greater than 1")
    @AssertTrue(message="ndjson codec (default codec) doesn't support max events per message greater than 1") boolean isValidCodecConfig() {
        return this.codec != null && !this.codec.getPluginName().equals("ndjson") || this.thresholdConfig.getMaxEventsPerMessage() <= 1;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    public SqsThresholdConfig getThresholdConfig() {
        return this.thresholdConfig;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDeDuplicationId() {
        return this.deDuplicationId;
    }

    public PluginModel getDlq() {
        return this.dlq;
    }
}

