/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.dataprepper.model.configuration.ConditionalRoute;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.pipeline.parser.InvalidPipelineConfigurationException;
import org.opensearch.dataprepper.pipeline.parser.model.PipelineConfiguration;
import org.opensearch.dataprepper.pipeline.parser.model.SinkContextPluginSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConfigurationValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineConfigurationValidator.class);
    private static final String PIPELINE_ATTRIBUTE_NAME = "name";
    private static final String PIPELINE_TYPE = "pipeline";
    private static final Set<String> INVALID_PIPELINE_NAMES = new HashSet<String>(List.of("data-prepper", "dataPrepper", "core"));
    private static final String DEFAULT_ROUTE = "_default";

    public static List<String> validateAndGetPipelineNames(Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        HashSet touchedPipelineSet = new HashSet();
        HashSet visitedAndProcessedPipelineSet = new HashSet();
        LinkedList<String> orderedPipelineNames = new LinkedList<String>();
        PipelineConfigurationValidator.checkInvalidPipelineNames(pipelineConfigurationMap);
        PipelineConfigurationValidator.validateSinkRoutes(pipelineConfigurationMap);
        pipelineConfigurationMap.forEach((pipeline, configuration) -> {
            if (!visitedAndProcessedPipelineSet.contains(pipeline)) {
                PipelineConfigurationValidator.visitAndValidate(pipeline, pipelineConfigurationMap, touchedPipelineSet, visitedAndProcessedPipelineSet, orderedPipelineNames);
            }
        });
        Collections.reverse(orderedPipelineNames);
        return orderedPipelineNames;
    }

    private static void checkInvalidPipelineNames(Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        Set<String> pipelineNames = pipelineConfigurationMap.keySet();
        Collection invalidPipelineNamesUsed = CollectionUtils.retainAll(pipelineNames, INVALID_PIPELINE_NAMES);
        if (!invalidPipelineNamesUsed.isEmpty()) {
            throw new RuntimeException(String.format("Cannot use %s as pipeline names.", invalidPipelineNamesUsed));
        }
    }

    private static void visitAndValidate(String pipeline, Map<String, PipelineConfiguration> pipelineConfigurationMap, Set<String> touchedPipelineSet, Set<String> visitedAndProcessedPipelineSet, List<String> sortedPipelineNames) {
        if (touchedPipelineSet.contains(pipeline)) {
            LOG.error("Configuration results in a cycle - check pipeline: {}", (Object)pipeline);
            throw new RuntimeException(String.format("Provided configuration results in a loop, check pipeline: %s", pipeline));
        }
        if (!visitedAndProcessedPipelineSet.contains(pipeline)) {
            PipelineConfiguration pipelineConfiguration = pipelineConfigurationMap.get(pipeline);
            touchedPipelineSet.add(pipeline);
            List<SinkContextPluginSetting> connectedPipelinesSettings = pipelineConfiguration.getSinkPluginSettings();
            for (PluginSetting pluginSetting : connectedPipelinesSettings) {
                if (!pluginSetting.getName().equals(PIPELINE_TYPE)) continue;
                String connectedPipelineName = (String)pluginSetting.getAttributeFromSettings(PIPELINE_ATTRIBUTE_NAME);
                PipelineConfigurationValidator.validatePipelineAttributeName(connectedPipelineName, pipeline);
                PipelineConfigurationValidator.validateSourceMapping(pipeline, connectedPipelineName, pipelineConfigurationMap);
                PipelineConfigurationValidator.visitAndValidate(connectedPipelineName, pipelineConfigurationMap, touchedPipelineSet, visitedAndProcessedPipelineSet, sortedPipelineNames);
            }
            visitedAndProcessedPipelineSet.add(pipeline);
            touchedPipelineSet.remove(pipeline);
            sortedPipelineNames.add(pipeline);
        }
    }

    private static void validateSourceMapping(String sourcePipeline, String currentPipeline, Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        if (!pipelineConfigurationMap.containsKey(currentPipeline)) {
            throw new RuntimeException(String.format("Invalid configuration, no pipeline is defined with name %s", currentPipeline));
        }
        PipelineConfiguration pipelineConfiguration = pipelineConfigurationMap.get(currentPipeline);
        PluginSetting sourcePluginSettings = pipelineConfiguration.getSourcePluginSetting();
        if (!PipelineConfigurationValidator.isPipelineAttributeExists(sourcePluginSettings, sourcePipeline)) {
            LOG.error("Invalid configuration, expected source {} for pipeline {} is missing", (Object)sourcePipeline, (Object)currentPipeline);
            throw new RuntimeException(String.format("Invalid configuration, expected source %s for pipeline %s is missing", sourcePipeline, currentPipeline));
        }
    }

    private static boolean isPipelineAttributeExists(PluginSetting pluginSetting, String pipelineName) {
        boolean result = false;
        if (pluginSetting != null && PIPELINE_TYPE.equals(pluginSetting.getName()) && pipelineName.equals(pluginSetting.getAttributeFromSettings(PIPELINE_ATTRIBUTE_NAME))) {
            result = true;
        }
        return result;
    }

    private static void validatePipelineAttributeName(String pipelineAttribute, String pipelineName) {
        if (pipelineAttribute == null || "".equals(pipelineAttribute.trim())) {
            throw new RuntimeException(String.format("name is a required attribute for sink pipeline plugin, check pipeline: %s", pipelineName));
        }
    }

    private static void validateForOrphans(List<String> sortedPipelines, Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        HashSet<String> expectedPipelineSet = new HashSet<String>();
        expectedPipelineSet.add(sortedPipelines.get(0));
        for (String currentPipelineName : sortedPipelines) {
            if (!expectedPipelineSet.contains(currentPipelineName)) {
                throw new RuntimeException("Invalid configuration, cannot proceed with ambiguous configuration");
            }
            PipelineConfiguration pipelineConfiguration = pipelineConfigurationMap.get(currentPipelineName);
            List<SinkContextPluginSetting> pluginSettings = pipelineConfiguration.getSinkPluginSettings();
            for (PluginSetting pluginSetting : pluginSettings) {
                if (!PIPELINE_TYPE.equals(pluginSetting.getName()) || pluginSetting.getAttributeFromSettings(PIPELINE_ATTRIBUTE_NAME) == null) continue;
                expectedPipelineSet.add((String)pluginSetting.getAttributeFromSettings(PIPELINE_ATTRIBUTE_NAME));
            }
        }
    }

    private static void validateSinkRoutes(Map<String, PipelineConfiguration> pipelineConfigurationMap) {
        for (Map.Entry<String, PipelineConfiguration> entry : pipelineConfigurationMap.entrySet()) {
            String pipelineName = entry.getKey();
            PipelineConfiguration pipelineConfiguration = entry.getValue();
            Set validRoutes = pipelineConfiguration.getRoutes().stream().map(ConditionalRoute::getName).collect(Collectors.toSet());
            List<SinkContextPluginSetting> sinkSettings = pipelineConfiguration.getSinkPluginSettings();
            for (SinkContextPluginSetting sinkPlugin : sinkSettings) {
                List invalidRoutes;
                List sinkRoutes = sinkPlugin.getSinkContext().getRoutes();
                if (sinkRoutes == null) {
                    sinkRoutes = Collections.emptyList();
                }
                if ((invalidRoutes = sinkRoutes.stream().filter(route -> !validRoutes.contains(route)).filter(route -> !route.equals(DEFAULT_ROUTE)).collect(Collectors.toList())).isEmpty()) continue;
                throw new InvalidPipelineConfigurationException(String.format("The following routes do not exist in pipeline \"%s\": %s. Configured routes include %s", pipelineName, invalidRoutes, validRoutes));
            }
        }
    }
}

