/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;
import software.amazon.cloudwatchlogs.emf.model.Unit;

class MetricDirective {
    @JsonProperty(value="Namespace")
    private String namespace;
    @JsonIgnore
    private Map<String, MetricDefinition> metrics;
    @JsonIgnore
    private List<DimensionSet> dimensions;
    @JsonIgnore
    private DimensionSet defaultDimensions;
    private boolean shouldUseDefaultDimension;

    MetricDirective() {
        this.namespace = "aws-embedded-metrics";
        this.metrics = new HashMap<String, MetricDefinition>();
        this.dimensions = new ArrayList<DimensionSet>();
        this.defaultDimensions = new DimensionSet();
        this.shouldUseDefaultDimension = true;
    }

    void putDimensionSet(DimensionSet dimensionSet) {
        this.dimensions.add(dimensionSet);
    }

    void putMetric(String key, double value) {
        this.putMetric(key, value, Unit.NONE);
    }

    void putMetric(String key, double value, Unit unit) {
        if (this.metrics.containsKey(key)) {
            this.metrics.get(key).addValue(value);
        } else {
            this.metrics.put(key, new MetricDefinition(key, unit, value));
        }
    }

    @JsonProperty(value="Metrics")
    Collection<MetricDefinition> getAllMetrics() {
        return this.metrics.values();
    }

    @JsonProperty(value="Dimensions")
    List<Set<String>> getAllDimensionKeys() {
        return this.getAllDimensions().stream().map(DimensionSet::getDimensionKeys).collect(Collectors.toList());
    }

    void setDimensions(List<DimensionSet> dimensionSets) {
        this.shouldUseDefaultDimension = false;
        this.dimensions = new ArrayList<DimensionSet>(dimensionSets);
    }

    List<DimensionSet> getAllDimensions() {
        if (!this.shouldUseDefaultDimension) {
            return this.dimensions;
        }
        if (this.dimensions.isEmpty()) {
            return Arrays.asList(this.defaultDimensions);
        }
        return this.dimensions.stream().map(dim -> this.defaultDimensions.add((DimensionSet)dim)).collect(Collectors.toList());
    }

    boolean hasNoMetrics() {
        return this.getMetrics().isEmpty();
    }

    MetricDirective copyWithoutMetrics() {
        MetricDirective metricDirective = new MetricDirective();
        metricDirective.setDefaultDimensions(this.defaultDimensions);
        metricDirective.setDimensions(this.dimensions);
        metricDirective.setNamespace(this.namespace);
        metricDirective.shouldUseDefaultDimension = this.shouldUseDefaultDimension;
        return metricDirective;
    }

    public MetricDirective(String namespace, Map<String, MetricDefinition> metrics, List<DimensionSet> dimensions, DimensionSet defaultDimensions, boolean shouldUseDefaultDimension) {
        this.namespace = namespace;
        this.metrics = metrics;
        this.dimensions = dimensions;
        this.defaultDimensions = defaultDimensions;
        this.shouldUseDefaultDimension = shouldUseDefaultDimension;
    }

    @JsonProperty(value="Namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setMetrics(Map<String, MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    public Map<String, MetricDefinition> getMetrics() {
        return this.metrics;
    }

    public MetricDirective withMetrics(Map<String, MetricDefinition> metrics) {
        return this.metrics == metrics ? this : new MetricDirective(this.namespace, metrics, this.dimensions, this.defaultDimensions, this.shouldUseDefaultDimension);
    }

    protected List<DimensionSet> getDimensions() {
        return this.dimensions;
    }

    public void setDefaultDimensions(DimensionSet defaultDimensions) {
        this.defaultDimensions = defaultDimensions;
    }

    protected DimensionSet getDefaultDimensions() {
        return this.defaultDimensions;
    }
}

