/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.inmemory;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.source.SourceCoordinationStore;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.plugins.sourcecoordinator.inmemory.InMemoryPartitionAccessor;
import org.opensearch.dataprepper.plugins.sourcecoordinator.inmemory.InMemorySourcePartitionStoreItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="in_memory", pluginType=SourceCoordinationStore.class)
public class InMemorySourceCoordinationStore
implements SourceCoordinationStore {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySourceCoordinationStore.class);
    private final InMemoryPartitionAccessor inMemoryPartitionAccessor;

    @DataPrepperPluginConstructor
    public InMemorySourceCoordinationStore(PluginSetting pluginSetting) {
        this(new InMemoryPartitionAccessor());
    }

    public InMemorySourceCoordinationStore(InMemoryPartitionAccessor inMemoryPartitionAccessor) {
        this.inMemoryPartitionAccessor = inMemoryPartitionAccessor;
    }

    public void initializeStore() {
        LOG.warn("The in_memory source coordination store is not recommended for production workloads. It is only effective in single node environments of Data Prepper, and can run into memory limitations over time if the number of partitions is too great.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SourcePartitionStoreItem> getSourcePartitionItem(String sourceIdentifier, String partitionKey) {
        InMemorySourceCoordinationStore inMemorySourceCoordinationStore = this;
        synchronized (inMemorySourceCoordinationStore) {
            return this.inMemoryPartitionAccessor.getItem(sourceIdentifier, partitionKey);
        }
    }

    public List<SourcePartitionStoreItem> querySourcePartitionItemsByStatus(String sourceIdentifier, SourcePartitionStatus sourcePartitionStatus, String startPartitionPriority) {
        throw new UnsupportedOperationException("querySourcePartitionItemsByStatus is currently not supported in In Memory Store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SourcePartitionStoreItem> queryAllSourcePartitionItems(String sourceIdentifier) {
        InMemorySourceCoordinationStore inMemorySourceCoordinationStore = this;
        synchronized (inMemorySourceCoordinationStore) {
            return this.inMemoryPartitionAccessor.getAllItem(sourceIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryCreatePartitionItem(String sourceIdentifier, String partitionKey, SourcePartitionStatus sourcePartitionStatus, Long closedCount, String partitionProgressState, boolean isReadOnlyItem) {
        InMemorySourceCoordinationStore inMemorySourceCoordinationStore = this;
        synchronized (inMemorySourceCoordinationStore) {
            if (this.inMemoryPartitionAccessor.getItem(sourceIdentifier, partitionKey).isEmpty()) {
                InMemorySourcePartitionStoreItem inMemorySourcePartitionStoreItem = new InMemorySourcePartitionStoreItem();
                inMemorySourcePartitionStoreItem.setSourceIdentifier(sourceIdentifier);
                inMemorySourcePartitionStoreItem.setSourcePartitionKey(partitionKey);
                inMemorySourcePartitionStoreItem.setSourcePartitionStatus(sourcePartitionStatus);
                inMemorySourcePartitionStoreItem.setClosedCount(closedCount);
                inMemorySourcePartitionStoreItem.setPartitionProgressState(partitionProgressState);
                this.inMemoryPartitionAccessor.queuePartition(inMemorySourcePartitionStoreItem);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<SourcePartitionStoreItem> tryAcquireAvailablePartition(String sourceIdentifier, String ownerId, Duration ownershipTimeout) {
        InMemorySourceCoordinationStore inMemorySourceCoordinationStore = this;
        synchronized (inMemorySourceCoordinationStore) {
            Optional<SourcePartitionStoreItem> nextItem = this.inMemoryPartitionAccessor.getNextItem();
            if (nextItem.isPresent()) {
                nextItem.get().setPartitionOwner(ownerId);
                nextItem.get().setPartitionOwnershipTimeout(Instant.now().plus(ownershipTimeout));
                nextItem.get().setSourcePartitionStatus(SourcePartitionStatus.ASSIGNED);
            }
            return nextItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryUpdateSourcePartitionItem(SourcePartitionStoreItem updateItem) {
        InMemorySourceCoordinationStore inMemorySourceCoordinationStore = this;
        synchronized (inMemorySourceCoordinationStore) {
            this.inMemoryPartitionAccessor.updateItem((InMemorySourcePartitionStoreItem)updateItem);
        }
    }

    public void tryUpdateSourcePartitionItem(SourcePartitionStoreItem updateItem, Instant priorityForUnassignedPartitions) {
        throw new UnsupportedOperationException();
    }

    public void tryDeletePartitionItem(SourcePartitionStoreItem deleteItem) {
        throw new UnsupportedOperationException("deleting partitions is not currently supported by the in memory source coordination store");
    }
}

