/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.inmemory;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStatus;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.plugins.sourcecoordinator.inmemory.InMemorySourcePartitionStoreItem;

public class InMemoryPartitionAccessor {
    static final String GLOBAL_STATE_ITEM_SUFFIX = "GLOBAL_STATE";
    private static final String SOURCE_IDENTIFIER_PARTITION_KEY_COMBINATION = "%s|%s";
    private final Queue<QueuedPartitionsItem> unassignedPartitions = new PriorityQueue<QueuedPartitionsItem>();
    private final Queue<QueuedPartitionsItem> closedPartitions = new PriorityQueue<QueuedPartitionsItem>();
    private final Set<String> completedPartitions = new HashSet<String>();
    private final Map<String, Map<String, InMemorySourcePartitionStoreItem>> partitionLookup = new HashMap<String, Map<String, InMemorySourcePartitionStoreItem>>();
    private final Map<String, InMemorySourcePartitionStoreItem> globalStateItems = new HashMap<String, InMemorySourcePartitionStoreItem>();

    public Optional<SourcePartitionStoreItem> getItem(String sourceIdentifier, String partitionKey) {
        String sourceIdentifierPartitionKey = String.format(SOURCE_IDENTIFIER_PARTITION_KEY_COMBINATION, sourceIdentifier, partitionKey);
        if (this.isGlobalStateItem(sourceIdentifier)) {
            return Optional.ofNullable((SourcePartitionStoreItem)this.globalStateItems.get(sourceIdentifierPartitionKey));
        }
        if (!this.partitionLookup.containsKey(sourceIdentifier)) {
            return Optional.empty();
        }
        if (this.completedPartitions.contains(sourceIdentifierPartitionKey)) {
            InMemorySourcePartitionStoreItem placeHolderItem = new InMemorySourcePartitionStoreItem();
            placeHolderItem.setSourcePartitionStatus(SourcePartitionStatus.COMPLETED);
            placeHolderItem.setSourceIdentifier(sourceIdentifier);
            placeHolderItem.setSourcePartitionKey(partitionKey);
            return Optional.of(placeHolderItem);
        }
        InMemorySourcePartitionStoreItem item = this.partitionLookup.get(sourceIdentifier).get(partitionKey);
        return Optional.ofNullable(item);
    }

    public List<SourcePartitionStoreItem> getAllItem(String sourceIdentifier) {
        if (!this.partitionLookup.containsKey(sourceIdentifier)) {
            return Collections.emptyList();
        }
        return new ArrayList<SourcePartitionStoreItem>(this.partitionLookup.get(sourceIdentifier).values());
    }

    public void queuePartition(InMemorySourcePartitionStoreItem inMemorySourcePartitionStoreItem) {
        if (this.isGlobalStateItem(inMemorySourcePartitionStoreItem.getSourceIdentifier())) {
            this.globalStateItems.put(String.format(SOURCE_IDENTIFIER_PARTITION_KEY_COMBINATION, inMemorySourcePartitionStoreItem.getSourceIdentifier(), inMemorySourcePartitionStoreItem.getSourcePartitionKey()), inMemorySourcePartitionStoreItem);
            return;
        }
        Map<String, InMemorySourcePartitionStoreItem> partitionMap = this.partitionLookup.get(inMemorySourcePartitionStoreItem.getSourceIdentifier());
        if (Objects.isNull(partitionMap)) {
            HashMap<String, InMemorySourcePartitionStoreItem> newPartitionMap = new HashMap<String, InMemorySourcePartitionStoreItem>();
            newPartitionMap.put(inMemorySourcePartitionStoreItem.getSourcePartitionKey(), inMemorySourcePartitionStoreItem);
            this.partitionLookup.put(inMemorySourcePartitionStoreItem.getSourceIdentifier(), newPartitionMap);
            this.queuePartitionItem(inMemorySourcePartitionStoreItem);
            return;
        }
        partitionMap.put(inMemorySourcePartitionStoreItem.getSourcePartitionKey(), inMemorySourcePartitionStoreItem);
        this.queuePartitionItem(inMemorySourcePartitionStoreItem);
    }

    public Optional<SourcePartitionStoreItem> getNextItem() {
        QueuedPartitionsItem nextUnassignedPartitionItem = this.unassignedPartitions.peek();
        if (Objects.nonNull(nextUnassignedPartitionItem) && this.partitionLookup.containsKey(nextUnassignedPartitionItem.sourceIdentifier)) {
            this.unassignedPartitions.remove();
            return Optional.ofNullable((SourcePartitionStoreItem)this.partitionLookup.get(nextUnassignedPartitionItem.sourceIdentifier).get(nextUnassignedPartitionItem.partitionKey));
        }
        QueuedPartitionsItem nextClosedPartitionItem = this.closedPartitions.peek();
        if (Objects.nonNull(nextClosedPartitionItem) && nextClosedPartitionItem.sortedTimestamp.isBefore(Instant.now()) && this.partitionLookup.containsKey(nextClosedPartitionItem.sourceIdentifier)) {
            this.closedPartitions.remove();
            return Optional.ofNullable((SourcePartitionStoreItem)this.partitionLookup.get(nextClosedPartitionItem.sourceIdentifier).get(nextClosedPartitionItem.partitionKey));
        }
        return Optional.empty();
    }

    public void updateItem(InMemorySourcePartitionStoreItem item) {
        String sourceIdentifierPartitionKey = String.format(SOURCE_IDENTIFIER_PARTITION_KEY_COMBINATION, item.getSourceIdentifier(), item.getSourcePartitionKey());
        if (this.isGlobalStateItem(item.getSourceIdentifier())) {
            this.globalStateItems.put(sourceIdentifierPartitionKey, item);
            return;
        }
        if (!this.partitionLookup.containsKey(item.getSourceIdentifier()) || this.completedPartitions.contains(sourceIdentifierPartitionKey)) {
            return;
        }
        if (SourcePartitionStatus.COMPLETED.equals((Object)item.getSourcePartitionStatus())) {
            this.completedPartitions.add(sourceIdentifierPartitionKey);
            this.partitionLookup.get(item.getSourceIdentifier()).remove(item.getSourcePartitionKey());
            return;
        }
        this.queuePartitionItem(item);
        this.partitionLookup.get(item.getSourceIdentifier()).put(item.getSourcePartitionKey(), item);
    }

    private void queuePartitionItem(InMemorySourcePartitionStoreItem inMemorySourcePartitionStoreItem) {
        if (SourcePartitionStatus.UNASSIGNED.equals((Object)inMemorySourcePartitionStoreItem.getSourcePartitionStatus())) {
            this.unassignedPartitions.add(new QueuedPartitionsItem(inMemorySourcePartitionStoreItem.getSourceIdentifier(), inMemorySourcePartitionStoreItem.getSourcePartitionKey(), Instant.now()));
        } else if (SourcePartitionStatus.CLOSED.equals((Object)inMemorySourcePartitionStoreItem.getSourcePartitionStatus())) {
            this.closedPartitions.add(new QueuedPartitionsItem(inMemorySourcePartitionStoreItem.getSourceIdentifier(), inMemorySourcePartitionStoreItem.getSourcePartitionKey(), inMemorySourcePartitionStoreItem.getReOpenAt()));
        }
    }

    private boolean isGlobalStateItem(String sourceIdentifier) {
        return sourceIdentifier.endsWith(GLOBAL_STATE_ITEM_SUFFIX);
    }

    protected static class QueuedPartitionsItem
    implements Comparable<QueuedPartitionsItem> {
        private final String sourceIdentifier;
        private final String partitionKey;
        private final Instant sortedTimestamp;

        public QueuedPartitionsItem(String sourceIdentifier, String partitionKey, Instant sortedTimestamp) {
            this.sourceIdentifier = sourceIdentifier;
            this.partitionKey = partitionKey;
            this.sortedTimestamp = sortedTimestamp;
        }

        @Override
        public int compareTo(QueuedPartitionsItem o) {
            if (Objects.isNull(this.sortedTimestamp) && Objects.isNull(o.sortedTimestamp)) {
                return 0;
            }
            if (Objects.isNull(this.sortedTimestamp)) {
                return -1;
            }
            if (Objects.isNull(o.sortedTimestamp)) {
                return 1;
            }
            return this.sortedTimestamp.compareTo(o.sortedTimestamp);
        }
    }
}

