/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.converter;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.dynamodb.configuration.StreamConfig;
import org.opensearch.dataprepper.plugins.source.dynamodb.converter.RecordConverter;
import org.opensearch.dataprepper.plugins.source.dynamodb.model.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.OperationType;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;

public class StreamRecordConverter
extends RecordConverter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamRecordConverter.class);
    static final String CHANGE_EVENTS_PROCESSED_COUNT = "changeEventsProcessed";
    static final String CHANGE_EVENTS_PROCESSING_ERROR_COUNT = "changeEventsProcessingErrors";
    static final String BYTES_RECEIVED = "bytesReceived";
    static final String BYTES_PROCESSED = "bytesProcessed";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private final StreamConfig streamConfig;
    private final PluginMetrics pluginMetrics;
    private final Counter changeEventSuccessCounter;
    private final Counter changeEventErrorCounter;
    private final DistributionSummary bytesReceivedSummary;
    private final DistributionSummary bytesProcessedSummary;
    private Instant currentSecond;
    private int recordsSeenThisSecond = 0;

    public StreamRecordConverter(BufferAccumulator<Record<Event>> bufferAccumulator, TableInfo tableInfo, PluginMetrics pluginMetrics, StreamConfig streamConfig) {
        super(bufferAccumulator, tableInfo);
        this.pluginMetrics = pluginMetrics;
        this.changeEventSuccessCounter = pluginMetrics.counter(CHANGE_EVENTS_PROCESSED_COUNT);
        this.changeEventErrorCounter = pluginMetrics.counter(CHANGE_EVENTS_PROCESSING_ERROR_COUNT);
        this.bytesReceivedSummary = pluginMetrics.summary(BYTES_RECEIVED);
        this.bytesProcessedSummary = pluginMetrics.summary(BYTES_PROCESSED);
        this.streamConfig = streamConfig;
    }

    @Override
    String getEventType() {
        return "STREAM";
    }

    public void writeToBuffer(AcknowledgementSet acknowledgementSet, List<software.amazon.awssdk.services.dynamodb.model.Record> records) {
        int eventCount = 0;
        for (software.amazon.awssdk.services.dynamodb.model.Record record : records) {
            Map<String, Object> keys;
            Map<String, Object> data;
            long bytes = record.dynamodb().sizeBytes();
            try {
                Map<String, AttributeValue> streamRecord = this.getStreamRecordFromImage(record);
                data = this.convertData(streamRecord);
                keys = this.convertKeys(record.dynamodb().keys());
            }
            catch (Exception e) {
                LOG.error("Failed to parse and convert data from stream due to {}", (Object)e.getMessage());
                this.changeEventErrorCounter.increment();
                continue;
            }
            try {
                this.bytesReceivedSummary.record((double)bytes);
                long eventCreationTimeMillis = this.calculateTieBreakingVersionFromTimestamp(record.dynamodb().approximateCreationDateTime());
                this.addToBuffer(acknowledgementSet, data, keys, record.dynamodb().approximateCreationDateTime().toEpochMilli(), eventCreationTimeMillis, record.eventNameAsString(), record.userIdentity());
                this.bytesProcessedSummary.record((double)bytes);
                ++eventCount;
            }
            catch (Exception e) {
                LOG.error("Failed to add event to buffer due to {}", (Object)e.getMessage());
                this.changeEventErrorCounter.increment();
            }
        }
        try {
            this.flushBuffer();
            this.changeEventSuccessCounter.increment((double)eventCount);
        }
        catch (Exception e) {
            LOG.error("Failed to write {} events to buffer due to {}", (Object)eventCount, (Object)e.getMessage());
            this.changeEventErrorCounter.increment((double)eventCount);
        }
    }

    private Object processAttributeValue(AttributeValue attributeValue) {
        switch (attributeValue.type()) {
            case N: {
                return new BigDecimal(attributeValue.n());
            }
            case B: {
                return BASE64_ENCODER.encodeToString(attributeValue.b().asByteArray());
            }
            case S: {
                return attributeValue.s();
            }
            case BOOL: {
                return attributeValue.bool();
            }
            case NS: {
                return attributeValue.ns().stream().map(BigDecimal::new).collect(Collectors.toSet());
            }
            case BS: {
                return attributeValue.bs().stream().map(buffer -> BASE64_ENCODER.encodeToString(buffer.asByteArray())).collect(Collectors.toSet());
            }
            case SS: {
                return attributeValue.ss();
            }
            case L: {
                return this.convertListData(attributeValue.l());
            }
            case M: {
                return this.convertData(attributeValue.m());
            }
            case NUL: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type: " + String.valueOf(attributeValue.type()));
    }

    private Map<String, Object> convertData(Map<String, AttributeValue> data) {
        return data.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), this.processAttributeValue((AttributeValue)entry.getValue())), HashMap::putAll);
    }

    private List<Object> convertListData(List<AttributeValue> data) {
        return data.stream().map(this::processAttributeValue).collect(Collectors.toList());
    }

    private Map<String, Object> convertKeys(Map<String, AttributeValue> keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        keys.forEach((attributeName, attributeValue) -> {
            if (attributeValue.type() == AttributeValue.Type.N) {
                result.put((String)attributeName, attributeValue.n());
            } else if (attributeValue.type() == AttributeValue.Type.B) {
                result.put((String)attributeName, attributeValue.b().toString());
            } else {
                result.put((String)attributeName, attributeValue.s());
            }
        });
        return result;
    }

    private long calculateTieBreakingVersionFromTimestamp(Instant eventTimeInSeconds) {
        if (this.currentSecond == null) {
            this.currentSecond = eventTimeInSeconds;
        } else {
            if (this.currentSecond.isAfter(eventTimeInSeconds)) {
                return eventTimeInSeconds.getEpochSecond() * 1000000L;
            }
            if (this.currentSecond.isBefore(eventTimeInSeconds)) {
                this.recordsSeenThisSecond = 0;
                this.currentSecond = eventTimeInSeconds;
            } else {
                ++this.recordsSeenThisSecond;
            }
        }
        return eventTimeInSeconds.getEpochSecond() * 1000000L + (long)this.recordsSeenThisSecond;
    }

    private Map<String, AttributeValue> getStreamRecordFromImage(software.amazon.awssdk.services.dynamodb.model.Record record) {
        if (!OperationType.REMOVE.equals((Object)record.eventName())) {
            return record.dynamodb().newImage();
        }
        if (StreamViewType.OLD_IMAGE.equals((Object)this.streamConfig.getStreamViewForRemoves())) {
            if (!record.dynamodb().hasOldImage()) {
                LOG.warn("view_on_remove with OLD_IMAGE is enabled, but no old image can be found on the stream record, using NEW_IMAGE");
                return record.dynamodb().newImage();
            }
            return record.dynamodb().oldImage();
        }
        return record.dynamodb().newImage();
    }
}

