/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.dynamodb.converter.RecordConverter;
import org.opensearch.dataprepper.plugins.source.dynamodb.model.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRecordConverter
extends RecordConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExportRecordConverter.class);
    private static final String ITEM_KEY = "Item";
    static final Duration VERSION_OVERLAP_TIME_FOR_EXPORT = Duration.ofMinutes(5L);
    static final String EXPORT_RECORDS_PROCESSED_COUNT = "exportRecordsProcessed";
    static final String EXPORT_RECORDS_PROCESSING_ERROR_COUNT = "exportRecordProcessingErrors";
    static final String BYTES_RECEIVED = "bytesReceived";
    static final String BYTES_PROCESSED = "bytesProcessed";
    IonObjectMapper MAPPER = new IonObjectMapper();
    private final PluginMetrics pluginMetrics;
    private final long exportStartTime;
    private final Counter exportRecordSuccessCounter;
    private final Counter exportRecordErrorCounter;
    private final DistributionSummary bytesReceivedSummary;
    private final DistributionSummary bytesProcessedSummary;

    public ExportRecordConverter(BufferAccumulator<Record<Event>> bufferAccumulator, TableInfo tableInfo, PluginMetrics pluginMetrics, long exportStartTime) {
        super(bufferAccumulator, tableInfo);
        this.pluginMetrics = pluginMetrics;
        this.exportRecordSuccessCounter = pluginMetrics.counter(EXPORT_RECORDS_PROCESSED_COUNT);
        this.exportRecordErrorCounter = pluginMetrics.counter(EXPORT_RECORDS_PROCESSING_ERROR_COUNT);
        this.bytesReceivedSummary = pluginMetrics.summary(BYTES_RECEIVED);
        this.bytesProcessedSummary = pluginMetrics.summary(BYTES_PROCESSED);
        this.exportStartTime = exportStartTime;
    }

    private Map<String, Object> convertToMap(String jsonData) {
        try {
            return (Map)this.MAPPER.readValue(jsonData, Map.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    @Override
    String getEventType() {
        return "EXPORT";
    }

    public void writeToBuffer(AcknowledgementSet acknowledgementSet, List<String> lines) {
        int eventCount = 0;
        for (String line : lines) {
            long bytes = line.getBytes().length;
            this.bytesReceivedSummary.record((double)bytes);
            Map data = (Map)this.convertToMap(line).get(ITEM_KEY);
            try {
                long eventVersionNumber = (this.exportStartTime - VERSION_OVERLAP_TIME_FOR_EXPORT.toMillis()) * 1000L;
                this.addToBuffer(acknowledgementSet, data, this.exportStartTime, eventVersionNumber);
                this.bytesProcessedSummary.record((double)bytes);
                ++eventCount;
            }
            catch (Exception e) {
                LOG.error("Failed to add event to buffer due to {}", (Object)e.getMessage());
            }
        }
        try {
            this.flushBuffer();
            this.exportRecordSuccessCounter.increment((double)eventCount);
        }
        catch (Exception e) {
            LOG.error("Failed to write {} events to buffer due to {}", (Object)eventCount, (Object)e.getMessage());
            this.exportRecordErrorCounter.increment((double)eventCount);
        }
    }
}

