/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.opensearch.dataprepper.plugins.source.dynamodb.configuration.AwsAuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.dynamodb.configuration.TableConfig;

public class DynamoDBSourceConfig {
    @JsonProperty(value="tables")
    @NotEmpty
    @NotNull
    @Valid
    private List<TableConfig> tableConfigs = Collections.emptyList();
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationConfig awsAuthenticationConfig;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="shard_acknowledgment_timeout")
    private Duration shardAcknowledgmentTimeout = Duration.ofMinutes(10L);
    @JsonProperty(value="s3_data_file_acknowledgment_timeout")
    private Duration dataFileAcknowledgmentTimeout = Duration.ofMinutes(15L);

    public List<TableConfig> getTableConfigs() {
        return this.tableConfigs;
    }

    public AwsAuthenticationConfig getAwsAuthenticationConfig() {
        return this.awsAuthenticationConfig;
    }

    public boolean isAcknowledgmentsEnabled() {
        return this.acknowledgments;
    }

    public Duration getShardAcknowledgmentTimeout() {
        return this.shardAcknowledgmentTimeout;
    }

    public Duration getDataFileAcknowledgmentTimeout() {
        return this.dataFileAcknowledgmentTimeout;
    }

    @AssertTrue(message="Exactly one table must be configured for the DynamoDb source.")
    @AssertTrue(message="Exactly one table must be configured for the DynamoDb source.") boolean isExactlyOneTableConfigured() {
        return this.tableConfigs.size() == 1;
    }
}

