/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.dynamodb;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.source.dynamodb.configuration.AwsAuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.dynamodb.configuration.ExportConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class ClientFactory {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final AwsAuthenticationConfig awsAuthenticationConfig;
    private final ExportConfig exportConfig;

    public ClientFactory(AwsCredentialsSupplier awsCredentialsSupplier, AwsAuthenticationConfig awsAuthenticationConfig, ExportConfig exportConfig) {
        this.awsCredentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(awsAuthenticationConfig.getAwsRegion()).withStsRoleArn(awsAuthenticationConfig.getAwsStsRoleArn()).withStsExternalId(awsAuthenticationConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsAuthenticationConfig.getAwsStsHeaderOverrides()).build());
        this.awsAuthenticationConfig = awsAuthenticationConfig;
        this.exportConfig = exportConfig;
    }

    public DynamoDbStreamsClient buildDynamoDbStreamClient() {
        return (DynamoDbStreamsClient)((DynamoDbStreamsClientBuilder)((DynamoDbStreamsClientBuilder)DynamoDbStreamsClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(this.awsAuthenticationConfig.getAwsRegion())).build();
    }

    public DynamoDbClient buildDynamoDBClient() {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(this.awsAuthenticationConfig.getAwsRegion())).credentialsProvider(this.awsCredentialsProvider)).build();
    }

    public S3Client buildS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.getS3ClientRegion())).credentialsProvider(this.awsCredentialsProvider)).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy -> retryPolicy.numRetries(Integer.valueOf(5)).build()).build())).build();
    }

    private Region getS3ClientRegion() {
        if (this.exportConfig != null && this.exportConfig.getAwsRegion() != null) {
            return this.exportConfig.getAwsRegion();
        }
        return this.awsAuthenticationConfig.getAwsRegion();
    }
}

