/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.utils;

import java.util.List;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.plugins.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.dlq.CloudWatchLogsSinkDlqData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchLogsSinkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchLogsSinkUtils.class);

    public static DlqObject createDlqObject(int status, EventHandle eventHandle, String message, String failureMessage, DlqPushHandler dlqPushHandler) {
        if (dlqPushHandler != null) {
            CloudWatchLogsSinkDlqData cloudWatchLogsSinkDlqData = CloudWatchLogsSinkDlqData.createDlqData(status, message, failureMessage);
            return DlqObject.createDlqObject((PluginSetting)dlqPushHandler.getPluginSetting(), List.of(eventHandle), (Object)cloudWatchLogsSinkDlqData);
        }
        eventHandle.release(false);
        return null;
    }

    public static void handleDlqObjects(List<DlqObject> dlqObjects, DlqPushHandler dlqPushHandler) {
        if (dlqObjects.size() == 0) {
            return;
        }
        boolean result = false;
        if (dlqPushHandler != null) {
            result = dlqPushHandler.perform(dlqObjects);
        }
        for (DlqObject dlqObject : dlqObjects) {
            dlqObject.releaseEventHandles(result);
        }
    }
}

