/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.utils;

public class CloudWatchLogsLimits {
    public static final int APPROXIMATE_LOG_EVENT_OVERHEAD_SIZE = 26;
    private final int maxBatchSize;
    private final long maxEventSizeBytes;
    private final long maxRequestSizeBytes;
    private final long logSendInterval;

    public CloudWatchLogsLimits(int maxBatchSize, long maxEventSizeBytes, long maxRequestSizeBytes, long logSendInterval) {
        this.maxBatchSize = maxBatchSize;
        this.maxEventSizeBytes = maxEventSizeBytes;
        this.maxRequestSizeBytes = maxRequestSizeBytes;
        this.logSendInterval = logSendInterval;
    }

    public boolean isTimeLimitReached(long elapsedTime) {
        return this.isGreaterEqualToLogSendInterval(elapsedTime);
    }

    public boolean isGreaterThanLimitReached(long currentTime, long currentRequestSize, int batchSize) {
        long bufferSizeWithOverhead = currentRequestSize + (long)batchSize * 26L;
        return this.isGreaterThanBatchSize(batchSize) || this.isGreaterEqualToLogSendInterval(currentTime) || this.isGreaterThanMaxRequestSize(bufferSizeWithOverhead);
    }

    public boolean maxRequestSizeLimitExceeds(long currentRequestSize, int batchSize) {
        long bufferSizeWithOverhead = currentRequestSize + (long)batchSize * 26L;
        return bufferSizeWithOverhead > this.maxRequestSizeBytes;
    }

    public boolean isMaxEventCountLimitReached(int batchSize) {
        return batchSize >= this.maxBatchSize;
    }

    public boolean isEqualToLimitReached(long currentRequestSize, int batchSize) {
        long bufferSizeWithOverhead = currentRequestSize + (long)batchSize * 26L;
        return this.isEqualBatchSize(batchSize) || this.isEqualMaxRequestSize(bufferSizeWithOverhead);
    }

    private boolean isGreaterEqualToLogSendInterval(long currentTimeSeconds) {
        return currentTimeSeconds >= this.logSendInterval;
    }

    public boolean isGreaterThanMaxEventSize(long eventSize) {
        return eventSize + 26L > this.maxEventSizeBytes;
    }

    private boolean isGreaterThanMaxRequestSize(long currentRequestSize) {
        return currentRequestSize > this.maxRequestSizeBytes;
    }

    private boolean isGreaterThanBatchSize(int batchSize) {
        return batchSize > this.maxBatchSize;
    }

    private boolean isEqualMaxRequestSize(long currentRequestSize) {
        return currentRequestSize == this.maxRequestSizeBytes;
    }

    private boolean isEqualBatchSize(int batchSize) {
        return batchSize == this.maxBatchSize;
    }
}

