/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.util;

import com.apptasticsoftware.rssreader.DateTime;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Item;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Comparator;
import java.util.Objects;

public final class ItemComparator {
    private ItemComparator() {
    }

    public static <I extends Item> Comparator<I> oldestItemFirst() {
        DateTime dateTime = new DateTime();
        return Comparator.comparing(i -> i.getPubDate().map(dateTime::toInstant).orElse(Instant.EPOCH));
    }

    public static <I extends Item> Comparator<I> oldestItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, "Date time parser must not be null");
        return Comparator.comparing(i -> i.getPubDate().map(dateTimeParser::parse).map(ChronoZonedDateTime::toInstant).orElse(Instant.EPOCH));
    }

    public static <I extends Item> Comparator<I> newestItemFirst() {
        DateTime dateTime = new DateTime();
        return Comparator.comparing(i -> i.getPubDate().map(dateTime::toInstant).orElse(Instant.EPOCH)).reversed();
    }

    public static <I extends Item> Comparator<I> newestItemFirst(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, "Date time parser must not be null");
        return Comparator.comparing(i -> i.getPubDate().map(dateTimeParser::parse).map(ChronoZonedDateTime::toInstant).orElse(Instant.EPOCH)).reversed();
    }

    public static <I extends Item> Comparator<I> channelTitle() {
        return Comparator.comparing(i -> i.getChannel().getTitle());
    }
}

