/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;

@SdkInternalApi
public class DeleteTableOperation<T>
implements TableOperation<T, DeleteTableRequest, DeleteTableResponse, Void> {
    public static <T> DeleteTableOperation<T> create() {
        return new DeleteTableOperation<T>();
    }

    @Override
    public OperationName operationName() {
        return OperationName.DELETE_ITEM;
    }

    @Override
    public DeleteTableRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("DeleteTable cannot be executed against a secondary index.");
        }
        return (DeleteTableRequest)DeleteTableRequest.builder().tableName(operationContext.tableName()).build();
    }

    @Override
    public Function<DeleteTableRequest, DeleteTableResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).deleteTable(arg_0);
    }

    @Override
    public Function<DeleteTableRequest, CompletableFuture<DeleteTableResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).deleteTable(arg_0);
    }

    @Override
    public Void transformResponse(DeleteTableResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        return null;
    }
}

