/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.parse;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.parse.CommonParseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParseProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractParseProcessor.class);
    private static final String PROCESSING_FAILURES = "processingFailures";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EventKey source;
    private final EventKey destination;
    private final String pointer;
    private final String parseWhen;
    private final List<String> tagsOnFailure;
    private final boolean overwriteIfDestinationExists;
    private final boolean deleteSourceRequested;
    private final HandleFailedEventsOption handleFailedEventsOption;
    protected final Counter processingFailuresCounter;
    private final ExpressionEvaluator expressionEvaluator;
    private final EventKeyFactory eventKeyFactory;

    protected AbstractParseProcessor(PluginMetrics pluginMetrics, CommonParseConfig commonParseConfig, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics);
        this.source = eventKeyFactory.createEventKey(commonParseConfig.getSource(), new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.GET, EventKeyFactory.EventAction.DELETE});
        this.destination = commonParseConfig.getDestination() != null ? eventKeyFactory.createEventKey(commonParseConfig.getDestination(), new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.PUT, EventKeyFactory.EventAction.GET}) : null;
        this.pointer = commonParseConfig.getPointer();
        this.parseWhen = commonParseConfig.getParseWhen();
        this.tagsOnFailure = commonParseConfig.getTagsOnFailure();
        this.overwriteIfDestinationExists = commonParseConfig.getOverwriteIfDestinationExists();
        this.deleteSourceRequested = commonParseConfig.isDeleteSourceRequested();
        this.handleFailedEventsOption = commonParseConfig.getHandleFailedEventsOption();
        this.processingFailuresCounter = pluginMetrics.counter(PROCESSING_FAILURES);
        this.expressionEvaluator = expressionEvaluator;
        this.eventKeyFactory = eventKeyFactory;
        if (commonParseConfig.getParseWhen() != null && !expressionEvaluator.isValidExpressionStatement(commonParseConfig.getParseWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("parse_when value of %s is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax.", commonParseConfig.getParseWhen()));
        }
    }

    protected abstract Optional<Map<String, Object>> readValue(String var1, Event var2);

    protected Map<String, Object> convertNestedObjectToString(Map<String, Object> map, int curDepth, int targetDepth) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    if (curDepth == targetDepth) {
                        resultMap.put(entry.getKey(), this.objectMapper.writeValueAsString((Object)((Map)entry.getValue())));
                        continue;
                    }
                    resultMap.put(entry.getKey(), this.convertNestedObjectToString((Map)entry.getValue(), curDepth + 1, targetDepth));
                    continue;
                }
                resultMap.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            LOG.atError().addMarker(DataPrepperMarkers.SENSITIVE).addMarker(DataPrepperMarkers.NOISY).setMessage("Failed to convert to string while parsing").setCause((Throwable)e).log();
        }
        return resultMap;
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        boolean doWriteToRoot = Objects.isNull(this.destination);
        boolean doUsePointer = Objects.nonNull(this.pointer);
        for (Record<Event> record : records) {
            try {
                String message;
                Event event = (Event)record.getData();
                if (Objects.nonNull(this.parseWhen) && !this.expressionEvaluator.evaluateConditional(this.parseWhen, event).booleanValue() || Objects.isNull(message = (String)event.get(this.source, String.class)) && !doUsePointer) continue;
                Optional<Map<String, Object>> parsedValueOptional = this.readValue(message, event);
                if (parsedValueOptional.isEmpty()) {
                    event.getMetadata().addTags(this.tagsOnFailure);
                    continue;
                }
                Map<String, Object> parsedValue = parsedValueOptional.get();
                if (doUsePointer) {
                    parsedValue = this.parseUsingPointer(event, parsedValue, this.pointer, doWriteToRoot);
                }
                if (doWriteToRoot) {
                    this.writeToRoot(event, parsedValue);
                } else if (this.overwriteIfDestinationExists || !event.containsKey(this.destination)) {
                    event.put(this.destination, parsedValue);
                }
                if (!this.deleteSourceRequested) continue;
                event.delete(this.source);
            }
            catch (Exception e) {
                this.processingFailuresCounter.increment();
                if (!this.handleFailedEventsOption.shouldLog()) continue;
                LOG.error(DataPrepperMarkers.EVENT, "An exception occurred while using the {} processor on Event [{}]", new Object[]{this.getProcessorName(), record.getData(), e});
            }
        }
        return records;
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }

    private String getProcessorName() {
        return ((Object)((Object)this)).getClass().getAnnotation(DataPrepperPlugin.class).name();
    }

    private Map<String, Object> parseUsingPointer(Event event, Map<String, Object> parsedJson, String pointer, boolean doWriteToRoot) {
        boolean shouldUseEntirePointerAsKey;
        JacksonEvent temporaryEvent = JacksonEvent.builder().withEventType("event").build();
        EventKey temporaryPutKey = this.eventKeyFactory.createEventKey(this.source.getKey(), new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.PUT});
        temporaryEvent.put(temporaryPutKey, parsedJson);
        String trimmedPointer = this.trimPointer(pointer);
        String actualPointer = String.valueOf(this.source) + "/" + trimmedPointer;
        boolean pointerIsValid = temporaryEvent.containsKey(actualPointer);
        if (!pointerIsValid) {
            LOG.error(DataPrepperMarkers.EVENT, "Writing entire source because the pointer {} is invalid on Event [{}]", (Object)pointer, (Object)event);
            return parsedJson;
        }
        Object valueAtPointer = temporaryEvent.get(actualPointer, Object.class);
        String endOfPointer = this.getEndOfPointer(trimmedPointer);
        boolean bl = shouldUseEntirePointerAsKey = event.containsKey(endOfPointer) && doWriteToRoot;
        if (shouldUseEntirePointerAsKey) {
            return Collections.singletonMap(this.normalizePointerStructure(trimmedPointer), valueAtPointer);
        }
        return Collections.singletonMap(this.normalizePointerStructure(endOfPointer), valueAtPointer);
    }

    private String getEndOfPointer(String trimmedPointer) {
        ArrayList<String> elements = new ArrayList<String>(Arrays.asList(trimmedPointer.split("/")));
        if (elements.size() <= 1) {
            return trimmedPointer;
        }
        boolean lastElementInPathIsAnArrayIndex = elements.get(elements.size() - 1).matches("[0-9]+");
        if (lastElementInPathIsAnArrayIndex) {
            return elements.get(elements.size() - 2) + "/" + elements.get(elements.size() - 1);
        }
        return elements.get(elements.size() - 1);
    }

    private String normalizePointerStructure(String pointer) {
        return pointer.replace('/', '.');
    }

    private String trimPointer(String pointer) {
        String trimmedLeadingSlash = pointer.startsWith("/") ? pointer.substring(1) : pointer;
        return trimmedLeadingSlash.endsWith("/") ? trimmedLeadingSlash.substring(0, trimmedLeadingSlash.length() - 1) : trimmedLeadingSlash;
    }

    private void writeToRoot(Event event, Map<String, Object> parsedJson) {
        for (Map.Entry<String, Object> entry : parsedJson.entrySet()) {
            if (!this.overwriteIfDestinationExists && event.containsKey(entry.getKey())) continue;
            event.put(this.eventKeyFactory.createEventKey(entry.getKey(), new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.PUT}), entry.getValue());
        }
    }
}

