/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.json.NdjsonOutputConfig;

@DataPrepperPlugin(name="ndjson", pluginType=OutputCodec.class, pluginConfigurationType=NdjsonOutputConfig.class)
public class NdjsonOutputCodec
implements OutputCodec {
    private static final String NDJSON = "ndjson";
    private OutputCodecContext deprecatedSupportCodecContext;

    @DataPrepperPluginConstructor
    public NdjsonOutputCodec(NdjsonOutputConfig config) {
        Objects.requireNonNull(config);
    }

    public OutputCodec.Writer createWriter(OutputStream outputStream, Event sampleEvent, OutputCodecContext codecContext) {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        return new NdjsonWriter(outputStream, codecContext);
    }

    public void start(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(codecContext);
        this.deprecatedSupportCodecContext = codecContext;
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(event);
        String json = event.jsonBuilder().includeKeys(this.deprecatedSupportCodecContext.getIncludeKeys()).excludeKeys(this.deprecatedSupportCodecContext.getExcludeKeys()).includeTags(this.deprecatedSupportCodecContext.getTagsTargetKey()).toJsonString();
        outputStream.write(json.getBytes());
        outputStream.write(System.lineSeparator().getBytes());
    }

    public void complete(OutputStream outputStream) throws IOException {
        outputStream.close();
    }

    public String getExtension() {
        return NDJSON;
    }

    private static void doWriteEvent(OutputStream outputStream, Event event, OutputCodecContext codecContext) throws IOException {
        Objects.requireNonNull(event);
        String json = event.jsonBuilder().includeKeys(codecContext.getIncludeKeys()).excludeKeys(codecContext.getExcludeKeys()).includeTags(codecContext.getTagsTargetKey()).toJsonString();
        outputStream.write(json.getBytes());
        outputStream.write(System.lineSeparator().getBytes());
    }

    private static class NdjsonWriter
    implements OutputCodec.Writer {
        private final OutputStream outputStream;
        private final OutputCodecContext codecContext;

        private NdjsonWriter(OutputStream outputStream, OutputCodecContext codecContext) {
            this.outputStream = outputStream;
            this.codecContext = codecContext;
        }

        public void writeEvent(Event event) throws IOException {
            NdjsonOutputCodec.doWriteEvent(this.outputStream, event, this.codecContext);
        }

        public void complete() throws IOException {
            this.outputStream.close();
        }
    }
}

