/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.opensearch.dataprepper.expression.ExpressionEvaluationException;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.OperatorProvider;
import org.opensearch.dataprepper.expression.ParseTreeCoercionService;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionBaseListener;
import org.opensearch.dataprepper.model.event.Event;

class ParseTreeEvaluatorListener
extends DataPrepperExpressionBaseListener {
    private final OperatorProvider operatorProvider;
    private final ParseTreeCoercionService coercionService;
    private final Stack<Integer> operatorSymbolStack;
    private final Stack<Object> operandStack;
    private final Event event;
    private boolean listStart;
    private Set<Object> setMembers;

    public ParseTreeEvaluatorListener(OperatorProvider operatorProvider, ParseTreeCoercionService coercionService, Event event) {
        this.coercionService = coercionService;
        this.operatorProvider = operatorProvider;
        this.event = event;
        this.listStart = false;
        this.operatorSymbolStack = new Stack();
        this.operandStack = new Stack();
    }

    public Object getResult() {
        if (this.operandStack.size() != 1) {
            throw new IllegalStateException("The ParseTreeEvaluatorListener has not been walked through exactly once by a ParseTreeWalker.");
        }
        return this.operandStack.peek();
    }

    private void validateSetMembers(Set<Object> setMembers) {
        int numbers = 0;
        int strings = 0;
        int booleans = 0;
        for (Object member : setMembers) {
            if (member instanceof Number) {
                ++numbers;
                continue;
            }
            if (member instanceof String) {
                ++strings;
                continue;
            }
            if (!(member instanceof Boolean)) continue;
            ++booleans;
        }
        if (numbers != setMembers.size() && strings != setMembers.size() && booleans != setMembers.size()) {
            throw new RuntimeException("All set members should be of same type");
        }
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        int nodeType = node.getSymbol().getType();
        if (nodeType == -1) {
            return;
        }
        if (this.operatorProvider.containsOperator(nodeType) || nodeType == 29) {
            this.operatorSymbolStack.push(nodeType);
        } else if (nodeType == 31) {
            this.listStart = true;
            this.setMembers = new HashSet<Object>();
        } else if (nodeType == 32) {
            this.listStart = false;
            this.validateSetMembers(this.setMembers);
            this.operandStack.push(this.setMembers);
        } else if (nodeType == 30) {
            this.operatorSymbolStack.pop();
        } else {
            Object arg = this.coercionService.coercePrimaryTerminalNode(node, this.event);
            if (this.listStart) {
                if (!(arg instanceof Integer) || (Integer)arg != 13 && (Integer)arg != 11) {
                    this.setMembers.add(arg);
                }
            } else {
                this.operandStack.push(arg);
            }
        }
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        throw new RuntimeException("Hit error node in the parse tree: " + node.getText());
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        Operator<?> op;
        int operatorSymbol;
        if (!this.operatorSymbolStack.isEmpty() && (operatorSymbol = this.operatorSymbolStack.peek().intValue()) != 29 && (op = this.operatorProvider.getOperator(operatorSymbol)).shouldEvaluate((RuleContext)ctx)) {
            this.operatorSymbolStack.pop();
            try {
                this.performSingleOperation(op, ctx);
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException && op.isBooleanOperator()) {
                    this.operandStack.push(false);
                }
                throw new ExpressionEvaluationException("Unable to evaluate the part of input statement: " + this.getPartialStatementFromContext(ctx), (Throwable)e);
            }
        }
    }

    private void performSingleOperation(Operator<?> operator, ParserRuleContext ctx) {
        int numOfArgs = operator.getNumberOfOperands((RuleContext)ctx);
        Object[] args = new Object[numOfArgs];
        for (int i = numOfArgs - 1; i >= 0; --i) {
            args[i] = this.operandStack.pop();
        }
        Object result = operator.evaluate(args);
        this.operandStack.push(result);
    }

    private String getPartialStatementFromContext(ParserRuleContext ctx) {
        Token startToken = ctx.getStart();
        Token stopToken = ctx.getStop();
        String fullStatement = startToken.getInputStream().toString();
        return fullStatement.substring(startToken.getStartIndex(), stopToken.getStopIndex() + 1);
    }
}

