/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.Operator;

@Named
class OperatorProvider {
    private final Map<Integer, Operator<?>> symbolToOperators;

    @Inject
    public OperatorProvider(List<Operator<?>> operators) {
        Preconditions.checkArgument((Objects.nonNull(operators) && operators.stream().allMatch(Objects::nonNull) ? 1 : 0) != 0, (Object)"Input operators should not contain null.");
        this.symbolToOperators = new HashMap();
        for (Operator<?> operator : operators) {
            this.symbolToOperators.put(operator.getSymbol(), operator);
        }
    }

    public Operator<?> getOperator(int symbol) {
        Operator<?> operator = this.symbolToOperators.get(symbol);
        if (operator == null) {
            throw new UnsupportedOperationException("Unsupported operator symbol index: " + symbol);
        }
        return operator;
    }

    public boolean containsOperator(int symbol) {
        return this.symbolToOperators.containsKey(symbol);
    }
}

