/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import java.util.function.Function;
import javax.inject.Named;
import org.opensearch.dataprepper.expression.ExpressionFunction;
import org.opensearch.dataprepper.model.event.Event;

@Named
public class LengthExpressionFunction
implements ExpressionFunction {
    @Override
    public String getFunctionName() {
        return "length";
    }

    @Override
    public Object evaluate(List<Object> args, Event event, Function<Object, Object> convertLiteralType) {
        if (args.size() != 1) {
            throw new RuntimeException("length() takes only one argument");
        }
        Object arg = args.get(0);
        if (!(arg instanceof String)) {
            throw new RuntimeException("length() takes only String type arguments");
        }
        String argStr = ((String)arg).trim();
        if (argStr.length() == 0) {
            return 0;
        }
        if (argStr.charAt(0) == '\"') {
            throw new RuntimeException("Literal strings not supported as arguments to length()");
        }
        Object value = event.get(argStr, Object.class);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new RuntimeException(argStr + " is not String type");
        }
        return ((String)value).length();
    }
}

