/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip;

import java.util.Collection;
import java.util.EnumSet;
import org.opensearch.dataprepper.plugins.geoip.GeoIPField;

public enum GeoIPDatabase {
    COUNTRY,
    CITY,
    ASN,
    ENTERPRISE;


    public static Collection<GeoIPDatabase> selectDatabasesForFields(Collection<GeoIPField> geoIPFields) {
        if (geoIPFields == null) {
            throw new NullPointerException("The geoIPFields parameter must be non-null.");
        }
        EnumSet<GeoIPDatabase> selectedDatabases = EnumSet.noneOf(GeoIPDatabase.class);
        for (GeoIPField geoIPField : geoIPFields) {
            selectedDatabases.addAll(GeoIPDatabase.leastCommonDatabase(geoIPField.getGeoIPDatabases()));
        }
        if (selectedDatabases.contains((Object)CITY)) {
            selectedDatabases.remove((Object)COUNTRY);
        }
        return selectedDatabases;
    }

    private static Collection<GeoIPDatabase> leastCommonDatabase(Collection<GeoIPDatabase> databases) {
        if (databases == null) {
            throw new NullPointerException("A null databases collection was provided to selectDatabases.");
        }
        EnumSet<GeoIPDatabase> selectedDatabases = EnumSet.copyOf(databases);
        if (selectedDatabases.contains((Object)CITY) && selectedDatabases.contains((Object)COUNTRY)) {
            selectedDatabases.remove((Object)CITY);
        }
        return selectedDatabases;
    }
}

