/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.GroupSequence;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.PersonalizeAdvancedValidation;
import org.opensearch.dataprepper.plugins.sink.personalize.dataset.DatasetTypeOptions;
import software.amazon.awssdk.arns.Arn;

@GroupSequence(value={PersonalizeSinkConfiguration.class, PersonalizeAdvancedValidation.class})
public class PersonalizeSinkConfiguration {
    private static final int DEFAULT_RETRIES = 10;
    private static final String AWS_PERSONALIZE = "personalize";
    private static final String AWS_PERSONALIZE_DATASET = "dataset";
    private static final List<DatasetTypeOptions> DATASET_ARN_REQUIRED_LIST = List.of(DatasetTypeOptions.USERS, DatasetTypeOptions.ITEMS);
    @JsonProperty(value="aws")
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonProperty(value="dataset_type")
    @NotNull
    @Valid
    private DatasetTypeOptions datasetType;
    @JsonProperty(value="dataset_arn")
    private String datasetArn;
    @JsonProperty(value="tracking_id")
    private String trackingId;
    @JsonProperty(value="document_root_key")
    private String documentRootKey;
    @JsonProperty(value="max_retries")
    private int maxRetries = 10;

    @AssertTrue(message="A dataset arn is required for items and users datasets.", groups={PersonalizeAdvancedValidation.class})
    @AssertTrue(message="A dataset arn is required for items and users datasets.", groups={PersonalizeAdvancedValidation.class}) boolean isDatasetArnProvidedWhenNeeded() {
        if (DATASET_ARN_REQUIRED_LIST.contains((Object)this.datasetType)) {
            return this.datasetArn != null;
        }
        return true;
    }

    @AssertTrue(message="dataset_arn must be a Personalize Dataset arn", groups={PersonalizeAdvancedValidation.class})
    @AssertTrue(message="dataset_arn must be a Personalize Dataset arn", groups={PersonalizeAdvancedValidation.class}) boolean isValidDatasetArn() {
        Optional resourceType;
        if (this.datasetArn == null) {
            return true;
        }
        Arn arn = this.getArn();
        boolean status = true;
        if (!AWS_PERSONALIZE.equals(arn.service())) {
            status = false;
        }
        if ((resourceType = arn.resource().resourceType()).isEmpty() || !((String)resourceType.get()).equals(AWS_PERSONALIZE_DATASET)) {
            status = false;
        }
        return status;
    }

    private Arn getArn() {
        try {
            return Arn.fromString((String)this.datasetArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for datasetArn. Check the format of %s", this.datasetArn), e);
        }
    }

    @AssertTrue(message="A tracking id is required for interactions dataset.", groups={PersonalizeAdvancedValidation.class})
    @AssertTrue(message="A tracking id is required for interactions dataset.", groups={PersonalizeAdvancedValidation.class}) boolean isTrackingIdProvidedWhenNeeded() {
        if (DatasetTypeOptions.INTERACTIONS.equals((Object)this.datasetType)) {
            return this.trackingId != null;
        }
        return true;
    }

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public DatasetTypeOptions getDatasetType() {
        return this.datasetType;
    }

    public String getDatasetArn() {
        return this.datasetArn;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public String getDocumentRootKey() {
        return this.documentRootKey;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

