/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.GroupSequence;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.sink.personalize.configuration.PersonalizeAdvancedValidation;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.regions.Region;

@GroupSequence(value={AwsAuthenticationOptions.class, PersonalizeAdvancedValidation.class})
public class AwsAuthenticationOptions {
    private static final String AWS_IAM_ROLE = "role";
    private static final String AWS_IAM = "iam";
    @JsonProperty(value="region")
    @Size(min=1, message="Region cannot be empty string")
    private @Size(min=1, message="Region cannot be empty string") String awsRegion;
    @JsonProperty(value="sts_role_arn")
    @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters")
    private @Size(min=20, max=2048, message="awsStsRoleArn length should be between 1 and 2048 characters") String awsStsRoleArn;
    @JsonProperty(value="sts_external_id")
    @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters")
    private @Size(min=2, max=1224, message="awsStsExternalId length should be between 2 and 1224 characters") String awsStsExternalId;
    @JsonProperty(value="sts_header_overrides")
    @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override")
    private @Size(max=5, message="sts_header_overrides supports a maximum of 5 headers to override") Map<String, String> awsStsHeaderOverrides;

    @AssertTrue(message="sts_role_arn must be an IAM Role", groups={PersonalizeAdvancedValidation.class})
    @AssertTrue(message="sts_role_arn must be an IAM Role", groups={PersonalizeAdvancedValidation.class}) boolean isValidStsRoleArn() {
        Optional resourceType;
        if (this.awsStsRoleArn == null) {
            return true;
        }
        Arn arn = this.getArn();
        boolean status = true;
        if (!AWS_IAM.equals(arn.service())) {
            status = false;
        }
        if ((resourceType = arn.resource().resourceType()).isEmpty() || !((String)resourceType.get()).equals(AWS_IAM_ROLE)) {
            status = false;
        }
        return status;
    }

    private Arn getArn() {
        try {
            return Arn.fromString((String)this.awsStsRoleArn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid ARN format for awsStsRoleArn. Check the format of %s", this.awsStsRoleArn));
        }
    }

    public Optional<Region> getAwsRegion() {
        Region region = this.awsRegion != null ? Region.of((String)this.awsRegion) : null;
        return Optional.ofNullable(region);
    }

    public String getAwsStsRoleArn() {
        return this.awsStsRoleArn;
    }

    public String getAwsStsExternalId() {
        return this.awsStsExternalId;
    }

    public Map<String, String> getAwsStsHeaderOverrides() {
        return this.awsStsHeaderOverrides;
    }
}

