/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.dynamicinference;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.returntypes.Neighbor;
import com.amazon.randomcutforest.testutils.ExampleDataSets;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class DynamicNearNeighbor
implements Example {
    public static void main(String[] args) throws Exception {
        new DynamicNearNeighbor().run();
    }

    @Override
    public String command() {
        return "dynamic_near_neighbor";
    }

    @Override
    public String description() {
        return "shows an example of dynamic near neighbor computation where both the data and query are evolving in time";
    }

    @Override
    public void run() throws Exception {
        int newDimensions = 2;
        long randomSeed = 123L;
        RandomCutForest newForest = RandomCutForest.builder().numberOfTrees(100).sampleSize(256).dimensions(newDimensions).randomSeed(randomSeed).timeDecay(0.00125).centerOfMassEnabled(true).storeSequenceIndexesEnabled(true).build();
        String name = "dynamic_near_neighbor_example";
        BufferedWriter file = new BufferedWriter(new FileWriter(name));
        double[][] data = ExampleDataSets.generate((int)1000);
        double[] queryPoint = new double[]{0.5, 0.6};
        for (int degree = 0; degree < 360; degree += 2) {
            for (double[] datum : data) {
                double[] transformed = ExampleDataSets.rotateClockWise((double[])datum, (double)(Math.PI * -2 * (double)degree / 360.0));
                file.append(transformed[0] + " " + transformed[1] + "\n");
                newForest.update(transformed);
            }
            file.append("\n");
            file.append("\n");
            double[] movingQuery = ExampleDataSets.rotateClockWise((double[])queryPoint, (double)(Math.PI * -3 * (double)degree / 360.0));
            float[] neighbor = ((Neighbor)newForest.getNearNeighborsInSample((double[])movingQuery, (double)1.0).get((int)0)).point;
            file.append(movingQuery[0] + " " + movingQuery[1] + " " + ((double)neighbor[0] - movingQuery[0]) + " " + ((double)neighbor[1] - movingQuery[1]) + "\n");
            file.append("\n");
            file.append("\n");
        }
    }
}

