/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.dynamicinference;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.returntypes.DensityOutput;
import com.amazon.randomcutforest.testutils.ExampleDataSets;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class DynamicDensity
implements Example {
    public static void main(String[] args) throws Exception {
        new DynamicDensity().run();
    }

    @Override
    public String command() {
        return "dynamic_sampling";
    }

    @Override
    public String description() {
        return "shows two potential use of dynamic density computations; estimating density as well as its directional components";
    }

    @Override
    public void run() throws Exception {
        int newDimensions = 2;
        long randomSeed = 123L;
        RandomCutForest newForest = RandomCutForest.builder().numberOfTrees(100).sampleSize(256).dimensions(newDimensions).randomSeed(randomSeed).timeDecay(0.00125).centerOfMassEnabled(true).build();
        String name = "dynamic_density_example";
        BufferedWriter file = new BufferedWriter(new FileWriter(name));
        double[][] data = ExampleDataSets.generate((int)1000);
        for (int degree = 0; degree < 360; degree += 2) {
            DensityOutput density;
            for (double[] datum : data) {
                newForest.update(ExampleDataSets.rotateClockWise((double[])datum, (double)(Math.PI * -2 * (double)degree / 360.0)));
            }
            for (double[] datum : data) {
                double[] queryPoint = ExampleDataSets.rotateClockWise((double[])datum, (double)(Math.PI * -2 * (double)degree / 360.0));
                density = newForest.getSimpleDensity(queryPoint);
                double value = density.getDensity(0.001, 2);
                file.append(queryPoint[0] + " " + queryPoint[1] + " " + value + "\n");
            }
            file.append("\n");
            file.append("\n");
            for (double x = -0.95; x < 1.0; x += 0.1) {
                for (double y = -0.95; y < 1.0; y += 0.1) {
                    density = newForest.getSimpleDensity(new double[]{x, y});
                    double aboveInY = density.getDirectionalDensity((double)0.001, (int)2).low[1];
                    double belowInY = density.getDirectionalDensity((double)0.001, (int)2).high[1];
                    double toTheLeft = density.getDirectionalDensity((double)0.001, (int)2).high[0];
                    double toTheRight = density.getDirectionalDensity((double)0.001, (int)2).low[0];
                    double len = Math.sqrt(aboveInY * aboveInY + belowInY * belowInY + toTheLeft * toTheLeft + toTheRight * toTheRight);
                    file.append(x + " " + y + " " + (toTheRight - toTheLeft) * 0.05 / len + " " + (aboveInY - belowInY) * 0.05 / len + "\n");
                }
            }
            file.append("\n");
            file.append("\n");
        }
        file.close();
    }
}

