/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.opensearch.dataprepper.aws.api.AwsConfig;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkConfig;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkService;
import org.opensearch.dataprepper.plugins.source.sqs.common.SqsClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

@Experimental
@DataPrepperPlugin(name="sqs", pluginType=Sink.class, pluginConfigurationType=SqsSinkConfig.class)
public class SqsSink
extends AbstractSink<Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(SqsSink.class);
    private static final Duration RETRY_FLUSH_BACKOFF = Duration.ofSeconds(5L);
    private final SqsSinkConfig sqsSinkConfig;
    private volatile boolean sinkInitialized;
    private final SqsSinkService sqsSinkService;

    @DataPrepperPluginConstructor
    public SqsSink(PluginSetting pluginSetting, PluginMetrics pluginMetrics, PluginFactory pluginFactory, SqsSinkConfig sqsSinkConfig, SinkContext sinkContext, ExpressionEvaluator expressionEvaluator, AwsCredentialsSupplier awsCredentialsSupplier) {
        super(pluginSetting);
        PluginSetting codecPluginSettings;
        this.sqsSinkConfig = sqsSinkConfig;
        this.sinkInitialized = false;
        PluginModel codecConfiguration = sqsSinkConfig.getCodec();
        if (codecConfiguration != null) {
            String codecPluginName = codecConfiguration.getPluginName();
            if (!codecPluginName.equals("json") && !codecPluginName.equals("ndjson")) {
                throw new RuntimeException(String.format("Codec {} not supported.", codecPluginName));
            }
            codecPluginSettings = new PluginSetting(codecConfiguration.getPluginName(), codecConfiguration.getPluginSettings());
        } else {
            codecPluginSettings = new PluginSetting("ndjson", Map.of());
        }
        AwsConfig awsConfig = sqsSinkConfig.getAwsConfig();
        AwsCredentialsProvider awsCredentialsProvider = awsConfig != null ? awsCredentialsSupplier.getProvider(SqsSink.convertToCredentialOptions(awsConfig)) : awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().build());
        Region region = awsConfig != null ? awsConfig.getAwsRegion() : (Region)awsCredentialsSupplier.getDefaultRegion().get();
        SqsClient sqsClient = SqsClientFactory.createSqsClient((Region)region, (AwsCredentialsProvider)awsCredentialsProvider);
        DlqPushHandler dlqPushHandler = null;
        if (sqsSinkConfig.getDlq() != null) {
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).build();
            String role = stsClient.getCallerIdentity().arn();
            dlqPushHandler = new DlqPushHandler(pluginFactory, pluginSetting, pluginMetrics, sqsSinkConfig.getDlq(), region.toString(), role, "sqsSink");
        }
        OutputCodec outputCodec = (OutputCodec)pluginFactory.loadPlugin(OutputCodec.class, codecPluginSettings, new Object[0]);
        this.sqsSinkService = new SqsSinkService(sqsSinkConfig, sqsClient, expressionEvaluator, outputCodec, sinkContext, dlqPushHandler, pluginMetrics);
    }

    private static AwsCredentialsOptions convertToCredentialOptions(AwsConfig awsConfig) {
        return AwsCredentialsOptions.builder().withRegion(awsConfig.getAwsRegion()).withStsRoleArn(awsConfig.getAwsStsRoleArn()).withStsExternalId(awsConfig.getAwsStsExternalId()).withStsHeaderOverrides(awsConfig.getAwsStsHeaderOverrides()).build();
    }

    public boolean isReady() {
        return this.sinkInitialized;
    }

    public void doInitialize() {
        this.sinkInitialized = true;
    }

    public void doOutput(Collection<Record<Event>> records) {
        this.sqsSinkService.output(records);
    }
}

