/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.opensearch.dataprepper.plugins.source.jira.models.IssueBean;
import org.opensearch.dataprepper.plugins.source.jira.utils.JiraContentType;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;

public class JiraItemInfo
implements ItemInfo {
    private String project;
    private String issueType;
    private String id;
    private String itemId;
    private Map<String, Object> metadata;
    private Instant eventTime;

    public JiraItemInfo(String id, String itemId, String project, String issueType, Map<String, Object> metadata, Instant eventTime) {
        this.id = id;
        this.project = project;
        this.issueType = issueType;
        this.itemId = itemId;
        this.metadata = metadata;
        this.eventTime = eventTime;
    }

    public static JiraItemInfoBuilder builder() {
        return new JiraItemInfoBuilder();
    }

    public String getPartitionKey() {
        return this.project + "|" + this.issueType + "|" + String.valueOf(UUID.randomUUID());
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getKeyAttributes() {
        return Map.of("project", this.project);
    }

    public Instant getLastModifiedAt() {
        long updatedAtMillis = this.getMetadataField("updated");
        long createdAtMillis = this.getMetadataField("created");
        return createdAtMillis > updatedAtMillis ? Instant.ofEpochMilli(createdAtMillis) : Instant.ofEpochMilli(updatedAtMillis);
    }

    private Long getMetadataField(String fieldName) {
        Object value = this.metadata.get(fieldName);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setEventTime(Instant eventTime) {
        this.eventTime = eventTime;
    }

    public String getProject() {
        return this.project;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getEventTime() {
        return this.eventTime;
    }

    public static class JiraItemInfoBuilder {
        private Map<String, Object> metadata;
        private Instant eventTime;
        private String id;
        private String itemId;
        private String project;
        private String issueType;

        public JiraItemInfo build() {
            return new JiraItemInfo(this.id, this.itemId, this.project, this.issueType, this.metadata, this.eventTime);
        }

        public JiraItemInfoBuilder withMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public JiraItemInfoBuilder withEventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public JiraItemInfoBuilder withItemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public JiraItemInfoBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public JiraItemInfoBuilder withProject(String project) {
            this.project = project;
            return this;
        }

        public JiraItemInfoBuilder withIssueBean(IssueBean issue) {
            HashMap<String, Object> issueMetadata = new HashMap<String, Object>();
            issueMetadata.put("j_project_key", issue.getProject());
            issueMetadata.put("j_project_name", issue.getProjectName());
            issueMetadata.put("created", issue.getCreatedTimeMillis());
            issueMetadata.put("updated", issue.getUpdatedTimeMillis());
            issueMetadata.put("j_issue_key", issue.getKey());
            issueMetadata.put("ContentType", JiraContentType.ISSUE.getType());
            this.project = issue.getProject();
            this.id = issue.getKey();
            this.issueType = JiraContentType.ISSUE.getType();
            this.itemId = "ISSUE-" + String.valueOf(issueMetadata.get("j_project_key")) + "-" + issue.getKey();
            this.metadata = issueMetadata;
            return this;
        }
    }
}

