/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MarshallerRegistry;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;
import org.curioswitch.common.protobuf.json.WellKnownTypeMarshaller;

public class MessageMarshaller {
    private static final SerializedString HTML_ESCAPED_LESS_THAN = new SerializedString("\\u003c");
    private static final SerializedString HTML_ESCAPED_GREATER_THAN = new SerializedString("\\u003e");
    private final JsonFactory jsonFactory = new JsonFactory().enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_COMMENTS).setCharacterEscapes(new CharacterEscapes(){

        public int[] getEscapeCodesForAscii() {
            int[] escapes = CharacterEscapes.standardAsciiEscapesForJSON();
            escapes[60] = -2;
            escapes[62] = -2;
            escapes[38] = -1;
            escapes[61] = -1;
            escapes[39] = -1;
            return escapes;
        }

        @Nullable
        public SerializableString getEscapeSequence(int ch) {
            switch (ch) {
                case 60: {
                    return HTML_ESCAPED_LESS_THAN;
                }
                case 62: {
                    return HTML_ESCAPED_GREATER_THAN;
                }
            }
            return null;
        }
    });
    @Nullable
    private final PrettyPrinter prettyPrinter;
    private final MarshallerRegistry registry;
    private final boolean includingDefaultValueFields;
    private final Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput;
    private final boolean preservingProtoFieldNames;
    private final boolean omittingInsignificantWhitespace;
    private final boolean ignoringUnknownFields;
    private final boolean printingEnumsAsInts;
    private final boolean sortingMapKeys;

    public static Builder builder() {
        return new Builder();
    }

    private MessageMarshaller(MarshallerRegistry registry, boolean omittingInsignificantWhitespace, boolean includingDefaultValueFields, Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput, boolean preservingProtoFieldNames, boolean ignoringUnknownFields, boolean printingEnumsAsInts, boolean sortingMapKeys) {
        this.prettyPrinter = omittingInsignificantWhitespace ? null : new MessagePrettyPrinter();
        this.registry = registry;
        this.omittingInsignificantWhitespace = omittingInsignificantWhitespace;
        this.includingDefaultValueFields = includingDefaultValueFields;
        this.fieldsToAlwaysOutput = fieldsToAlwaysOutput;
        this.preservingProtoFieldNames = preservingProtoFieldNames;
        this.ignoringUnknownFields = ignoringUnknownFields;
        this.printingEnumsAsInts = printingEnumsAsInts;
        this.sortingMapKeys = sortingMapKeys;
    }

    public void mergeValue(byte[] json, Message.Builder builder) throws IOException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(builder, "builder");
        try (JsonParser parser = this.jsonFactory.createParser(json);){
            this.mergeValue(parser, builder);
        }
    }

    public void mergeValue(String json, Message.Builder builder) throws IOException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(builder, "builder");
        try (JsonParser parser = this.jsonFactory.createParser(json);){
            this.mergeValue(parser, builder);
        }
    }

    public void mergeValue(InputStream json, Message.Builder builder) throws IOException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(builder, "builder");
        try (JsonParser parser = this.jsonFactory.createParser(json);){
            this.mergeValue(parser, builder);
        }
    }

    public void mergeValue(JsonParser jsonParser, Message.Builder builder) throws IOException {
        Objects.requireNonNull(jsonParser, "jsonParser");
        Objects.requireNonNull(builder, "builder");
        TypeSpecificMarshaller<?> parser = this.registry.findForPrototype(builder.getDefaultInstanceForType());
        try {
            parser.mergeValue(jsonParser, 0, builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e);
        }
    }

    public <T extends Message> byte[] writeValueAsBytes(T message) throws IOException {
        Objects.requireNonNull(message, "message");
        ByteArrayBuilder builder = new ByteArrayBuilder(this.jsonFactory._getBufferRecycler());
        try (JsonGenerator gen = this.jsonFactory.createGenerator((OutputStream)builder);){
            this.writeValue(message, gen);
        }
        return builder.toByteArray();
    }

    public <T extends Message> String writeValueAsString(T message) throws IOException {
        Objects.requireNonNull(message, "message");
        SegmentedStringWriter sw = new SegmentedStringWriter(this.jsonFactory._getBufferRecycler());
        try (JsonGenerator gen = this.jsonFactory.createGenerator((Writer)sw);){
            this.writeValue(message, gen);
        }
        return sw.getAndClear();
    }

    public <T extends Message> void writeValue(T message, OutputStream out) throws IOException {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(out, "out");
        try (JsonGenerator gen = this.jsonFactory.createGenerator(out);){
            this.writeValue(message, gen);
        }
    }

    public <T extends Message> void writeValue(T message, JsonGenerator gen) throws IOException {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(gen, "gen");
        TypeSpecificMarshaller<?> serializer = this.registry.findForPrototype(message.getDefaultInstanceForType());
        if (this.prettyPrinter != null) {
            gen.setPrettyPrinter(this.prettyPrinter);
        }
        try {
            serializer.writeValue(message, gen);
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e);
        }
    }

    public Builder toBuilder() {
        return new Builder(this.registry.getBuiltParsers(), this.omittingInsignificantWhitespace, this.includingDefaultValueFields, this.fieldsToAlwaysOutput, this.preservingProtoFieldNames, this.ignoringUnknownFields, this.printingEnumsAsInts, this.sortingMapKeys);
    }

    List<? extends Message> registeredPrototypes() {
        return this.registry.getBuiltParsers().values().stream().map(TypeSpecificMarshaller::getMarshalledPrototype).collect(Collectors.toList());
    }

    public static final class Builder {
        private boolean includingDefaultValueFields;
        private Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput = Collections.emptySet();
        private boolean preservingProtoFieldNames;
        private boolean omittingInsignificantWhitespace;
        private boolean ignoringUnknownFields;
        private boolean printingEnumsAsInts;
        private boolean sortingMapKeys;
        private final List<Message> prototypes = new ArrayList<Message>();
        private final Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> preBuiltParsers;

        public Builder register(Message prototype) {
            Objects.requireNonNull(prototype, "prototype");
            this.prototypes.add(prototype.getDefaultInstanceForType());
            return this;
        }

        public Builder register(Class<? extends Message> messageClass) {
            Objects.requireNonNull(messageClass, "messageClass");
            try {
                return this.register((Message)messageClass.getDeclaredMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("No getDefaultInstance method on a Message class, this can never happen.", e);
            }
        }

        public Builder includingDefaultValueFields(boolean includingDefaultValueFields) {
            this.includingDefaultValueFields = includingDefaultValueFields;
            this.fieldsToAlwaysOutput = Collections.emptySet();
            return this;
        }

        public Builder includingDefaultValueFields(Descriptors.FieldDescriptor ... fieldsToAlwaysOutput) {
            Objects.requireNonNull(fieldsToAlwaysOutput, "fieldsToAlwaysOutput");
            this.includingDefaultValueFields(Arrays.asList(fieldsToAlwaysOutput));
            return this;
        }

        public Builder includingDefaultValueFields(Iterable<Descriptors.FieldDescriptor> fieldsToAlwaysOutput) {
            Objects.requireNonNull(fieldsToAlwaysOutput, "fieldsToAlwaysOutput");
            this.includingDefaultValueFields = false;
            this.fieldsToAlwaysOutput = new HashSet<Descriptors.FieldDescriptor>();
            fieldsToAlwaysOutput.forEach(this.fieldsToAlwaysOutput::add);
            return this;
        }

        public Builder preservingProtoFieldNames(boolean preservingProtoFieldNames) {
            this.preservingProtoFieldNames = preservingProtoFieldNames;
            return this;
        }

        public Builder omittingInsignificantWhitespace(boolean omittingInsignificantWhitespace) {
            this.omittingInsignificantWhitespace = omittingInsignificantWhitespace;
            return this;
        }

        public Builder ignoringUnknownFields(boolean ignoringUnknownFields) {
            this.ignoringUnknownFields = ignoringUnknownFields;
            return this;
        }

        public Builder printingEnumsAsInts(boolean printingEnumsAsInts) {
            this.printingEnumsAsInts = printingEnumsAsInts;
            return this;
        }

        public Builder sortingMapKeys(boolean sortingMapKeys) {
            this.sortingMapKeys = sortingMapKeys;
            return this;
        }

        public MessageMarshaller build() {
            HashMap<Descriptors.Descriptor, TypeSpecificMarshaller<?>> builtParsers;
            if (!this.preBuiltParsers.isEmpty()) {
                builtParsers = new HashMap(this.preBuiltParsers);
            } else {
                builtParsers = new HashMap();
                Builder.addStandardParser(WellKnownTypeMarshaller.BoolValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.Int32ValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.UInt32ValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.Int64ValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.UInt64ValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.StringValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.BytesValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.FloatValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.DoubleValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.TimestampMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.DurationMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.FieldMaskMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.StructMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.ValueMarshaller.INSTANCE, builtParsers);
                Builder.addStandardParser(WellKnownTypeMarshaller.ListValueMarshaller.INSTANCE, builtParsers);
            }
            WellKnownTypeMarshaller.AnyMarshaller anyParser = new WellKnownTypeMarshaller.AnyMarshaller();
            Builder.addStandardParser(anyParser, builtParsers);
            for (Message prototype : this.prototypes) {
                TypeSpecificMarshaller.buildAndAdd(prototype, this.includingDefaultValueFields, this.fieldsToAlwaysOutput, this.preservingProtoFieldNames, this.ignoringUnknownFields, this.printingEnumsAsInts, this.sortingMapKeys, builtParsers);
            }
            MarshallerRegistry registry = new MarshallerRegistry(builtParsers);
            anyParser.setMarshallerRegistry(registry);
            return new MessageMarshaller(registry, this.omittingInsignificantWhitespace, this.includingDefaultValueFields, this.fieldsToAlwaysOutput, this.preservingProtoFieldNames, this.ignoringUnknownFields, this.printingEnumsAsInts, this.sortingMapKeys);
        }

        private static <T extends Message> void addStandardParser(TypeSpecificMarshaller<T> marshaller, Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> marshallers) {
            marshallers.put(marshaller.getDescriptorForMarshalledType(), marshaller);
        }

        private Builder() {
            this.preBuiltParsers = Collections.emptyMap();
        }

        Builder(Map<Descriptors.Descriptor, TypeSpecificMarshaller<?>> preBuiltParsers, boolean omittingInsignificantWhitespace, boolean includingDefaultValueFields, Set<Descriptors.FieldDescriptor> fieldsToAlwaysOutput, boolean preservingProtoFieldNames, boolean ignoringUnknownFields, boolean printingEnumsAsInts, boolean sortingMapKeys) {
            this.preBuiltParsers = preBuiltParsers;
            this.omittingInsignificantWhitespace = omittingInsignificantWhitespace;
            this.includingDefaultValueFields = includingDefaultValueFields;
            this.fieldsToAlwaysOutput = fieldsToAlwaysOutput;
            this.preservingProtoFieldNames = preservingProtoFieldNames;
            this.ignoringUnknownFields = ignoringUnknownFields;
            this.printingEnumsAsInts = printingEnumsAsInts;
            this.sortingMapKeys = sortingMapKeys;
        }
    }

    private static class MessagePrettyPrinter
    extends DefaultPrettyPrinter {
        private static final long serialVersionUID = -822596512575275305L;

        private MessagePrettyPrinter() {
            this._objectIndenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n");
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(": ");
        }

        public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException {
            if (!this._objectIndenter.isInline()) {
                --this._nesting;
            }
            this._objectIndenter.writeIndentation(jg, this._nesting);
            jg.writeRaw('}');
        }

        public void beforeArrayValues(JsonGenerator jg) throws IOException {
        }

        public void writeEndArray(JsonGenerator gen, int nrOfValues) throws IOException {
            gen.writeRaw(']');
        }
    }
}

