/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Credential
implements PlainJsonSerializable {
    @Nullable
    private final String accessKey;
    @Nullable
    private final String secretKey;
    @Nullable
    private final String sessionToken;
    @Nonnull
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<Credential> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Credential::setupCredentialDeserializer);

    private Credential(Builder builder) {
        this.accessKey = builder.accessKey;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
    }

    public static Credential of(Function<Builder, ObjectBuilder<Credential>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String accessKey() {
        return this.accessKey;
    }

    @Nullable
    public final String secretKey() {
        return this.secretKey;
    }

    @Nullable
    public final String sessionToken() {
        return this.sessionToken;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.accessKey != null) {
            generator.writeKey("access_key");
            generator.write(this.accessKey);
        }
        if (this.secretKey != null) {
            generator.writeKey("secret_key");
            generator.write(this.secretKey);
        }
        if (this.sessionToken != null) {
            generator.writeKey("session_token");
            generator.write(this.sessionToken);
        }
    }

    protected static void setupCredentialDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessKey, JsonpDeserializer.stringDeserializer(), "access_key");
        op.add(Builder::secretKey, JsonpDeserializer.stringDeserializer(), "secret_key");
        op.add(Builder::sessionToken, JsonpDeserializer.stringDeserializer(), "session_token");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.accessKey);
        result = 31 * result + Objects.hashCode(this.secretKey);
        result = 31 * result + Objects.hashCode(this.sessionToken);
        result = 31 * result + Objects.hashCode(this.metadata);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential other = (Credential)o;
        return Objects.equals(this.accessKey, other.accessKey) && Objects.equals(this.secretKey, other.secretKey) && Objects.equals(this.sessionToken, other.sessionToken) && Objects.equals(this.metadata, other.metadata);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Credential> {
        @Nullable
        private String accessKey;
        @Nullable
        private String secretKey;
        @Nullable
        private String sessionToken;
        @Nullable
        private Map<String, JsonData> metadata;

        public final Builder accessKey(@Nullable String value) {
            this.accessKey = value;
            return this;
        }

        public final Builder secretKey(@Nullable String value) {
            this.secretKey = value;
            return this;
        }

        public final Builder sessionToken(@Nullable String value) {
            this.sessionToken = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Override
        public Credential build() {
            this._checkSingleUse();
            return new Credential(this);
        }
    }
}

