/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.LegacyESVersion;
import org.opensearch.common.Explicit;
import org.opensearch.common.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DynamicTemplate;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TypeParsers;

public class RootObjectMapper
extends ObjectMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RootObjectMapper.class);
    private Explicit<DateFormatter[]> dynamicDateTimeFormatters;
    private Explicit<Boolean> dateDetection;
    private Explicit<Boolean> numericDetection;
    private Explicit<DynamicTemplate[]> dynamicTemplates;

    public void fixRedundantIncludes() {
        RootObjectMapper.fixRedundantIncludes(this, true);
    }

    private static void fixRedundantIncludes(ObjectMapper objectMapper, boolean parentIncluded) {
        for (Mapper mapper : objectMapper) {
            boolean includedInRoot;
            if (!(mapper instanceof ObjectMapper)) continue;
            ObjectMapper child = (ObjectMapper)mapper;
            ObjectMapper.Nested nested = child.nested();
            boolean isNested = nested.isNested();
            boolean includeInRootViaParent = parentIncluded && isNested && nested.isIncludeInParent();
            boolean bl = includedInRoot = isNested && nested.isIncludeInRoot();
            if (includeInRootViaParent && includedInRoot) {
                nested.setIncludeInParent(true);
                nested.setIncludeInRoot(false);
            }
            RootObjectMapper.fixRedundantIncludes(child, includeInRootViaParent || includedInRoot);
        }
    }

    RootObjectMapper(String name, Explicit<Boolean> enabled, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Explicit<DateFormatter[]> dynamicDateTimeFormatters, Explicit<DynamicTemplate[]> dynamicTemplates, Explicit<Boolean> dateDetection, Explicit<Boolean> numericDetection, Settings settings) {
        super(name, name, enabled, ObjectMapper.Nested.NO, dynamic, mappers, settings);
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    @Override
    public ObjectMapper mappingUpdate(Mapper mapper) {
        RootObjectMapper update = (RootObjectMapper)super.mappingUpdate(mapper);
        update.dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        update.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        update.dateDetection = new Explicit<Boolean>(true, false);
        update.numericDetection = new Explicit<Boolean>(false, false);
        return update;
    }

    public boolean dateDetection() {
        return this.dateDetection.value();
    }

    public boolean numericDetection() {
        return this.numericDetection.value();
    }

    public DateFormatter[] dynamicDateTimeFormatters() {
        return this.dynamicDateTimeFormatters.value();
    }

    public DynamicTemplate[] dynamicTemplates() {
        return this.dynamicTemplates.value();
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType) {
        return this.findTemplateBuilder(context, name, matchType, null);
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, DateFormatter dateFormatter) {
        return this.findTemplateBuilder(context, name, DynamicTemplate.XContentFieldType.DATE, dateFormatter);
    }

    private Mapper.Builder findTemplateBuilder(ParseContext context, String name, DynamicTemplate.XContentFieldType matchType, DateFormatter dateFormat) {
        String mappingType;
        DynamicTemplate dynamicTemplate = this.findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        String dynamicType = matchType.defaultMappingType();
        Mapper.TypeParser.ParserContext parserContext = context.docMapperParser().parserContext(dateFormat);
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType = dynamicTemplate.mappingType(dynamicType));
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, dynamicTemplate.mappingForName(name, dynamicType), parserContext);
    }

    public DynamicTemplate findTemplate(ContentPath path, String name, DynamicTemplate.XContentFieldType matchType) {
        String pathAsString = path.pathAsText(name);
        for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
            if (!dynamicTemplate.match(pathAsString, name, matchType)) continue;
            return dynamicTemplate;
        }
        return null;
    }

    @Override
    public RootObjectMapper merge(Mapper mergeWith, MapperService.MergeReason reason) {
        return (RootObjectMapper)super.merge(mergeWith, reason);
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith, MapperService.MergeReason reason) {
        super.doMerge(mergeWith, reason);
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (mergeWithObject.numericDetection.explicit()) {
            this.numericDetection = mergeWithObject.numericDetection;
        }
        if (mergeWithObject.dateDetection.explicit()) {
            this.dateDetection = mergeWithObject.dateDetection;
        }
        if (mergeWithObject.dynamicDateTimeFormatters.explicit()) {
            this.dynamicDateTimeFormatters = mergeWithObject.dynamicDateTimeFormatters;
        }
        if (mergeWithObject.dynamicTemplates.explicit()) {
            if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                LinkedHashMap<String, DynamicTemplate> templatesByKey = new LinkedHashMap<String, DynamicTemplate>();
                for (DynamicTemplate template : this.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                for (DynamicTemplate template : mergeWithObject.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                DynamicTemplate[] mergedTemplates = templatesByKey.values().toArray(new DynamicTemplate[0]);
                this.dynamicTemplates = new Explicit<DynamicTemplate[]>(mergedTemplates, true);
            } else {
                this.dynamicTemplates = mergeWithObject.dynamicTemplates;
            }
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (this.dynamicDateTimeFormatters.explicit() || includeDefaults) {
            builder.startArray("dynamic_date_formats");
            for (DateFormatter dateTimeFormatter : this.dynamicDateTimeFormatters.value()) {
                builder.value(dateTimeFormatter.pattern());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates.explicit() || includeDefaults) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
                builder.startObject();
                builder.field(dynamicTemplate.name(), (ToXContent)dynamicTemplate);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.dateDetection.explicit() || includeDefaults) {
            builder.field("date_detection", this.dateDetection.value());
        }
        if (this.numericDetection.explicit() || includeDefaults) {
            builder.field("numeric_detection", this.numericDetection.value());
        }
    }

    private static void validateDynamicTemplate(Mapper.TypeParser.ParserContext parserContext, DynamicTemplate dynamicTemplate) {
        if (RootObjectMapper.containsSnippet(dynamicTemplate.getMapping(), "{name}")) {
            return;
        }
        DynamicTemplate.XContentFieldType[] types = dynamicTemplate.getXContentFieldType() != null ? new DynamicTemplate.XContentFieldType[]{dynamicTemplate.getXContentFieldType()} : DynamicTemplate.XContentFieldType.values();
        Exception lastError = null;
        boolean dynamicTemplateInvalid = true;
        for (DynamicTemplate.XContentFieldType contentFieldType : types) {
            String defaultDynamicType = contentFieldType.defaultMappingType();
            String mappingType = dynamicTemplate.mappingType(defaultDynamicType);
            Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
            if (typeParser == null) {
                lastError = new IllegalArgumentException("No mapper found for type [" + mappingType + "]");
                continue;
            }
            String templateName = "__dynamic__" + dynamicTemplate.name();
            Map<String, Object> fieldTypeConfig = dynamicTemplate.mappingForName(templateName, defaultDynamicType);
            try {
                Mapper.Builder<?> dummyBuilder = typeParser.parse(templateName, fieldTypeConfig, parserContext);
                fieldTypeConfig.remove("type");
                if (fieldTypeConfig.isEmpty()) {
                    Settings indexSettings = parserContext.mapperService().getIndexSettings().getSettings();
                    Mapper.BuilderContext builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
                    dummyBuilder.build(builderContext);
                    dynamicTemplateInvalid = false;
                    break;
                }
                lastError = new IllegalArgumentException("Unused mapping attributes [" + fieldTypeConfig + "]");
            }
            catch (Exception e) {
                lastError = e;
            }
        }
        boolean shouldEmitDeprecationWarning = parserContext.indexVersionCreated().onOrAfter(LegacyESVersion.V_7_7_0);
        if (dynamicTemplateInvalid && shouldEmitDeprecationWarning) {
            String message = String.format(Locale.ROOT, "dynamic template [%s] has invalid content [%s]", dynamicTemplate.getName(), Strings.toString((ToXContent)dynamicTemplate));
            String deprecationMessage = lastError != null ? String.format(Locale.ROOT, "%s, caused by [%s]", message, lastError.getMessage()) : message;
            DEPRECATION_LOGGER.deprecate("invalid_dynamic_template_" + dynamicTemplate.getName(), deprecationMessage, new Object[0]);
        }
    }

    private static boolean containsSnippet(Map<?, ?> map, String snippet) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String valueString;
            String key = entry.getKey().toString();
            if (key.contains(snippet)) {
                return true;
            }
            Object value = entry.getValue();
            if (!(value instanceof Map ? RootObjectMapper.containsSnippet((Map)value, snippet) : (value instanceof List ? RootObjectMapper.containsSnippet((List)value, snippet) : value instanceof String && (valueString = (String)value).contains(snippet)))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(List<?> list, String snippet) {
        for (Object value : list) {
            String valueString;
            if (!(value instanceof Map ? RootObjectMapper.containsSnippet((Map)value, snippet) : (value instanceof List ? RootObjectMapper.containsSnippet((List)value, snippet) : value instanceof String && (valueString = (String)value).contains(snippet)))) continue;
            return true;
        }
        return false;
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !this.processField(builder, fieldName, fieldNode, parserContext)) continue;
                iterator.remove();
            }
            return builder;
        }

        protected boolean processField(Builder builder, String fieldName, Object fieldNode, Mapper.TypeParser.ParserContext parserContext) {
            if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
                if (fieldNode instanceof List) {
                    ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>();
                    for (Object formatter : (List)fieldNode) {
                        if (formatter.toString().startsWith("epoch_")) {
                            throw new MapperParsingException("Epoch [" + formatter + "] is not supported as dynamic date format");
                        }
                        formatters.add(TypeParsers.parseDateTimeFormatter(formatter));
                    }
                    builder.dynamicDateTimeFormatter(formatters);
                } else if ("none".equals(fieldNode.toString())) {
                    builder.dynamicDateTimeFormatter(Collections.emptyList());
                } else {
                    builder.dynamicDateTimeFormatter(Collections.singleton(TypeParsers.parseDateTimeFormatter(fieldNode)));
                }
                return true;
            }
            if (fieldName.equals("dynamic_templates")) {
                if (!(fieldNode instanceof List)) {
                    throw new MapperParsingException("Dynamic template syntax error. An array of named objects is expected.");
                }
                List tmplNodes = (List)fieldNode;
                ArrayList<DynamicTemplate> templates = new ArrayList<DynamicTemplate>();
                for (Object tmplNode : tmplNodes) {
                    Map templateParams;
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    String templateName = (String)entry.getKey();
                    DynamicTemplate template = DynamicTemplate.parse(templateName, templateParams = (Map)entry.getValue(), parserContext.indexVersionCreated());
                    if (template == null) continue;
                    RootObjectMapper.validateDynamicTemplate(parserContext, template);
                    templates.add(template);
                }
                builder.dynamicTemplates(templates);
                return true;
            }
            if (fieldName.equals("date_detection")) {
                builder.dateDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "date_detection"), true);
                return true;
            }
            if (fieldName.equals("numeric_detection")) {
                builder.numericDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "numeric_detection"), true);
                return true;
            }
            return false;
        }
    }

    public static class Builder
    extends ObjectMapper.Builder<Builder> {
        protected Explicit<DynamicTemplate[]> dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        protected Explicit<DateFormatter[]> dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        protected Explicit<Boolean> dateDetection = new Explicit<Boolean>(true, false);
        protected Explicit<Boolean> numericDetection = new Explicit<Boolean>(false, false);

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder dynamicDateTimeFormatter(Collection<DateFormatter> dateTimeFormatters) {
            this.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(dateTimeFormatters.toArray(new DateFormatter[0]), true);
            return this;
        }

        public Builder dynamicTemplates(Collection<DynamicTemplate> templates) {
            this.dynamicTemplates = new Explicit<DynamicTemplate[]>(templates.toArray(new DynamicTemplate[0]), true);
            return this;
        }

        @Override
        public RootObjectMapper build(Mapper.BuilderContext context) {
            return (RootObjectMapper)super.build(context);
        }

        @Override
        protected ObjectMapper createMapper(String name, String fullPath, Explicit<Boolean> enabled, ObjectMapper.Nested nested, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, @Nullable Settings settings) {
            assert (!nested.isNested());
            return new RootObjectMapper(name, enabled, dynamic, mappers, this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection, settings);
        }
    }

    public static class Defaults {
        public static final DateFormatter[] DYNAMIC_DATE_TIME_FORMATTERS = new DateFormatter[]{DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, DateFormatter.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis")};
        public static final boolean DATE_DETECTION = true;
        public static final boolean NUMERIC_DETECTION = false;
    }
}

