/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugin.ExtensionPluginConfigurationResolver;

@Named
public class ExtensionPluginConfigurationConverter {
    static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final ExtensionPluginConfigurationResolver extensionPluginConfigurationResolver;
    private final ObjectMapper objectMapper;
    private final Validator validator;

    @Inject
    public ExtensionPluginConfigurationConverter(ExtensionPluginConfigurationResolver extensionPluginConfigurationResolver, Validator validator, @Named(value="extensionPluginConfigObjectMapper") ObjectMapper objectMapper) {
        this.extensionPluginConfigurationResolver = extensionPluginConfigurationResolver;
        this.objectMapper = objectMapper;
        this.validator = validator;
    }

    public Object convert(boolean configAllowedInPipelineConfigurations, Class<?> extensionPluginConfigurationType, String rootKey) {
        Set constraintViolations;
        Objects.requireNonNull(extensionPluginConfigurationType);
        Objects.requireNonNull(rootKey);
        Object configuration = configAllowedInPipelineConfigurations ? this.convertSettings(extensionPluginConfigurationType, this.getExtensionPluginConfigMap(this.extensionPluginConfigurationResolver.getCombinedExtensionMap(), rootKey)) : this.convertSettings(extensionPluginConfigurationType, this.getExtensionPluginConfigMap(this.extensionPluginConfigurationResolver.getDataPrepperConfigExtensionMap(), rootKey));
        Set set = constraintViolations = configuration == null ? Collections.emptySet() : this.validator.validate(configuration, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            String violationsString = constraintViolations.stream().map(v -> v.getPropertyPath().toString() + " " + v.getMessage()).collect(Collectors.joining(". "));
            String exceptionMessage = String.format("Extension %s in PipelineExtensions is configured incorrectly: %s", rootKey, violationsString);
            throw new InvalidPluginConfigurationException(exceptionMessage);
        }
        return configuration;
    }

    private Object convertSettings(Class<?> extensionPluginConfigurationType, Object extensionPlugin) {
        return this.objectMapper.convertValue(extensionPlugin, extensionPluginConfigurationType);
    }

    private Map<String, Object> getExtensionPluginConfigMap(Map<String, Object> extensionMap, String rootKey) {
        JsonNode jsonNode = this.objectMapper.valueToTree(extensionMap);
        JsonPointer jsonPointer = JsonPointer.compile((String)rootKey);
        JsonNode extensionPluginConfigNode = jsonNode.at(jsonPointer);
        return (Map)this.objectMapper.convertValue((Object)extensionPluginConfigNode, MAP_TYPE_REFERENCE);
    }
}

