/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.function.Consumer;
import javax.inject.Named;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.plugin.DefinedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DeprecatedPluginDetector
implements Consumer<DefinedPlugin<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DeprecatedPluginDetector.class);

    DeprecatedPluginDetector() {
    }

    @Override
    public void accept(DefinedPlugin<?> definedPlugin) {
        this.logDeprecatedPluginsNames(definedPlugin.getPluginClass(), definedPlugin.getPluginName());
    }

    private void logDeprecatedPluginsNames(Class<?> pluginClass, String pluginName) {
        String deprecatedName = pluginClass.getAnnotation(DataPrepperPlugin.class).deprecatedName();
        String name = pluginClass.getAnnotation(DataPrepperPlugin.class).name();
        if (deprecatedName.equals(pluginName)) {
            LOG.warn("Plugin name '{}' is deprecated and will be removed in the next major release. Consider using the updated plugin name '{}'.", (Object)deprecatedName, (Object)name);
        }
    }
}

