/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Map;
import org.opensearch.dataprepper.aws.validator.AwsAccountId;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.NotificationSourceOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.NotificationTypeOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.OnErrorOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3ScanScanOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectOptions;
import org.opensearch.dataprepper.plugins.source.s3.configuration.SqsOptions;

public class S3SourceConfig {
    static final Duration DEFAULT_BUFFER_TIMEOUT = Duration.ofSeconds(10L);
    static final Duration DEFAULT_BACKOFF_MILLIS = Duration.ofMillis(30000L);
    static final int DEFAULT_NUMBER_OF_WORKERS = 1;
    static final int DEFAULT_NUMBER_OF_RECORDS_TO_ACCUMULATE = 100;
    static final String DEFAULT_METADATA_ROOT_KEY = "s3/";
    @JsonProperty(value="notification_type")
    private NotificationTypeOption notificationType;
    @JsonProperty(value="notification_source")
    private NotificationSourceOption notificationSource = NotificationSourceOption.S3;
    @JsonProperty(value="compression")
    private CompressionOption compression = CompressionOption.NONE;
    @JsonProperty(value="codec")
    private PluginModel codec;
    @JsonProperty(value="sqs")
    @Valid
    private SqsOptions sqsOptions;
    @JsonProperty(value="workers")
    @Min(value=1L)
    @Max(value=1000L)
    @Valid
    private @Min(value=1L) @Max(value=1000L) @Valid int numWorkers = 1;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationOptions awsAuthenticationOptions;
    @JsonProperty(value="on_error")
    private OnErrorOption onErrorOption = OnErrorOption.RETAIN_MESSAGES;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="buffer_timeout")
    private Duration bufferTimeout = DEFAULT_BUFFER_TIMEOUT;
    @JsonProperty(value="records_to_accumulate")
    private int numberOfRecordsToAccumulate = 100;
    @JsonProperty(value="disable_bucket_ownership_validation")
    private boolean disableBucketOwnershipValidation = false;
    @JsonProperty(value="bucket_owners")
    private Map<String, @AwsAccountId String> bucketOwners;
    @JsonProperty(value="backoff_time")
    private Duration backOff = DEFAULT_BACKOFF_MILLIS;
    @JsonProperty(value="default_bucket_owner")
    @AwsAccountId
    private String defaultBucketOwner;
    @JsonProperty(value="metadata_root_key")
    private String metadataRootKey = "s3/";
    @JsonProperty(value="s3_select")
    @Valid
    private S3SelectOptions s3SelectOptions;
    @JsonProperty(value="scan")
    @Valid
    private S3ScanScanOptions s3ScanScanOptions;
    @JsonProperty(value="delete_s3_objects_on_read")
    private boolean deleteS3ObjectsOnRead = false;
    @JsonProperty(value="disable_s3_metadata_in_event")
    private boolean deleteS3MetadataInEvent = false;

    @AssertTrue(message="A codec is required for reading objects.")
    @AssertTrue(message="A codec is required for reading objects.") boolean isCodecProvidedWhenNeeded() {
        if (this.s3SelectOptions == null) {
            return this.codec != null;
        }
        return true;
    }

    @AssertTrue(message="acknowledgments and delete_s3_objects_on_read must both be set to true when using folder_partitions mode")
    @AssertTrue(message="acknowledgments and delete_s3_objects_on_read must both be set to true when using folder_partitions mode") boolean isPrefixPartitionModeValid() {
        if (this.s3ScanScanOptions != null && this.s3ScanScanOptions.getPartitioningOptions() != null) {
            return this.acknowledgments && this.deleteS3ObjectsOnRead;
        }
        return true;
    }

    @AssertTrue(message="acknowledgments must be enabled when using delete_s3_objects_on_read")
    @AssertTrue(message="acknowledgments must be enabled when using delete_s3_objects_on_read") boolean isAcknowledgmentsEnabledWithDeleteS3ObjectsOnRead() {
        return !this.deleteS3ObjectsOnRead || this.acknowledgments;
    }

    @AssertTrue(message="s3_select is not supported with delete_s3_objects_on_read")
    @AssertTrue(message="s3_select is not supported with delete_s3_objects_on_read") boolean isS3SelectNotUsingDeleteS3ObjectsOnRead() {
        return this.s3SelectOptions == null || !this.deleteS3ObjectsOnRead;
    }

    public NotificationTypeOption getNotificationType() {
        return this.notificationType;
    }

    public Duration getBackOff() {
        return this.backOff;
    }

    public NotificationSourceOption getNotificationSource() {
        return this.notificationSource;
    }

    boolean getAcknowledgements() {
        return this.acknowledgments;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public CompressionOption getCompression() {
        return this.compression;
    }

    public PluginModel getCodec() {
        return this.codec;
    }

    public SqsOptions getSqsOptions() {
        return this.sqsOptions;
    }

    public AwsAuthenticationOptions getAwsAuthenticationOptions() {
        return this.awsAuthenticationOptions;
    }

    public OnErrorOption getOnErrorOption() {
        return this.onErrorOption;
    }

    public Duration getBufferTimeout() {
        return this.bufferTimeout;
    }

    public int getNumberOfRecordsToAccumulate() {
        return this.numberOfRecordsToAccumulate;
    }

    public boolean isDisableBucketOwnershipValidation() {
        return this.disableBucketOwnershipValidation;
    }

    public String getMetadataRootKey() {
        return this.metadataRootKey;
    }

    public S3SelectOptions getS3SelectOptions() {
        return this.s3SelectOptions;
    }

    public S3ScanScanOptions getS3ScanScanOptions() {
        return this.s3ScanScanOptions;
    }

    public boolean isDeleteS3ObjectsOnRead() {
        return this.deleteS3ObjectsOnRead;
    }

    public Map<String, String> getBucketOwners() {
        return this.bucketOwners;
    }

    public String getDefaultBucketOwner() {
        return this.defaultBucketOwner;
    }

    public boolean isDeleteS3MetadataInEvent() {
        return this.deleteS3MetadataInEvent;
    }
}

