/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.io.input.CountingInputStream;
import org.opensearch.dataprepper.buffer.common.BufferAccumulator;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.SourceCoordinator;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectHandler;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectPluginMetrics;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectReference;
import org.opensearch.dataprepper.plugins.source.s3.S3ObjectRequest;
import org.opensearch.dataprepper.plugins.source.s3.S3SelectResponseHandler;
import org.opensearch.dataprepper.plugins.source.s3.S3SelectResponseHandlerFactory;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceProgressState;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3DataSelection;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectCSVOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectJsonOption;
import org.opensearch.dataprepper.plugins.source.s3.configuration.S3SelectSerializationFormatOption;
import org.opensearch.dataprepper.plugins.source.s3.ownership.BucketOwnerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CompressionType;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.InputSerialization;
import software.amazon.awssdk.services.s3.model.RecordsEvent;
import software.amazon.awssdk.services.s3.model.ScanRange;
import software.amazon.awssdk.services.s3.model.SelectObjectContentEventStream;
import software.amazon.awssdk.services.s3.model.SelectObjectContentRequest;
import software.amazon.awssdk.services.s3.model.SelectObjectContentResponseHandler;
import software.amazon.awssdk.utils.builder.SdkBuilder;

public class S3SelectObjectWorker
implements S3ObjectHandler {
    private static final Logger LOG = LoggerFactory.getLogger(S3SelectObjectWorker.class);
    static final long MAX_S3_OBJECT_CHUNK_SIZE = 0x4000000L;
    static final String S3_BUCKET_NAME = "bucket";
    static final String S3_OBJECT_KEY = "key";
    static final String S3_BUCKET_REFERENCE_NAME = "s3";
    static final String CSV_FILE_HEADER_INFO_NONE = "none";
    static final String JSON_LINES_TYPE = "LINES";
    private final S3AsyncClient s3AsyncClient;
    private final Duration bufferTimeout;
    private final int numberOfRecordsToAccumulate;
    private final Buffer<Record<Event>> buffer;
    private final String expression;
    private final S3SelectSerializationFormatOption serializationFormatOption;
    private final S3SelectResponseHandlerFactory s3SelectResponseHandlerFactory;
    private final S3ObjectPluginMetrics s3ObjectPluginMetrics;
    private final CompressionType compressionType;
    private final BiConsumer<Event, S3ObjectReference> eventConsumer;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFactory jsonFactory = new JsonFactory();
    private final S3SelectCSVOption s3SelectCSVOption;
    private final S3SelectJsonOption s3SelectJsonOption;
    private final String expressionType;
    private final BucketOwnerProvider bucketOwnerProvider;

    public S3SelectObjectWorker(S3ObjectRequest s3ObjectRequest) {
        this.buffer = s3ObjectRequest.getBuffer();
        this.numberOfRecordsToAccumulate = s3ObjectRequest.getNumberOfRecordsToAccumulate();
        this.bufferTimeout = s3ObjectRequest.getBufferTimeout();
        this.expression = s3ObjectRequest.getExpression();
        this.serializationFormatOption = s3ObjectRequest.getSerializationFormatOption();
        this.s3AsyncClient = s3ObjectRequest.getS3AsyncClient();
        this.s3SelectResponseHandlerFactory = s3ObjectRequest.getS3SelectResponseHandlerFactory();
        this.s3ObjectPluginMetrics = s3ObjectRequest.getS3ObjectPluginMetrics();
        this.compressionType = s3ObjectRequest.getCompressionType();
        this.eventConsumer = s3ObjectRequest.getEventConsumer();
        this.s3SelectCSVOption = s3ObjectRequest.getS3SelectCSVOption();
        this.s3SelectJsonOption = s3ObjectRequest.getS3SelectJsonOption();
        this.expressionType = s3ObjectRequest.getExpressionType();
        this.bucketOwnerProvider = s3ObjectRequest.getBucketOwnerProvider();
    }

    @Override
    public void processS3Object(S3ObjectReference s3ObjectReference, S3DataSelection dataSelection, AcknowledgementSet acknowledgementSet, SourceCoordinator<S3SourceProgressState> sourceCoordinator, String partitionKey) throws IOException {
        try {
            LOG.info("Read S3 object: {}", (Object)s3ObjectReference);
            this.selectObject(s3ObjectReference, acknowledgementSet);
        }
        catch (Exception e) {
            LOG.error("Unable to process object reference: {}", (Object)s3ObjectReference, (Object)e);
            this.s3ObjectPluginMetrics.getS3ObjectsFailedCounter().increment();
            throw new IOException(e);
        }
    }

    @Override
    public void deleteS3Object(S3ObjectReference s3ObjectReference) {
        throw new UnsupportedOperationException("Deleting S3 objects is not supported with S3 select");
    }

    private void selectObject(S3ObjectReference s3ObjectReference, AcknowledgementSet acknowledgementSet) throws IOException {
        InputSerialization inputSerialization = this.getInputSerializationFormat(this.serializationFormatOption);
        BufferAccumulator bufferAccumulator = BufferAccumulator.create(this.buffer, (int)this.numberOfRecordsToAccumulate, (Duration)this.bufferTimeout);
        if (this.isScanRangeSupported()) {
            this.selectObjectInBatches(s3ObjectReference, acknowledgementSet, inputSerialization, (BufferAccumulator<Record<Event>>)bufferAccumulator);
        } else {
            SelectObjectContentRequest selectObjectContentRequest = this.getS3SelectObjRequest(s3ObjectReference, inputSerialization, null);
            this.processSelectObjectRequest(selectObjectContentRequest, s3ObjectReference, acknowledgementSet, (BufferAccumulator<Record<Event>>)bufferAccumulator);
        }
        this.s3ObjectPluginMetrics.getS3ObjectsSucceededCounter().increment();
    }

    private boolean isScanRangeSupported() {
        return this.isScanRangeSupportedForParquetConfiguration() || this.isScanRangeSupportedForJsonConfiguration() || this.isScanRangeSupportedForCsvConfiguration();
    }

    private boolean isScanRangeSupportedForParquetConfiguration() {
        return S3SelectSerializationFormatOption.PARQUET.equals((Object)this.serializationFormatOption);
    }

    private boolean isScanRangeSupportedForJsonConfiguration() {
        return S3SelectSerializationFormatOption.JSON.equals((Object)this.serializationFormatOption) && Objects.nonNull(this.s3SelectJsonOption) && this.s3SelectJsonOption.getType().equalsIgnoreCase(JSON_LINES_TYPE) && CompressionType.NONE.equals((Object)this.compressionType);
    }

    private boolean isScanRangeSupportedForCsvConfiguration() {
        return S3SelectSerializationFormatOption.CSV.equals((Object)this.serializationFormatOption) && Objects.nonNull(this.s3SelectCSVOption) && !this.isQuotedRecordDelimiterAllowed() && CompressionType.NONE.equals((Object)this.compressionType);
    }

    private void selectObjectInBatches(S3ObjectReference s3ObjectReference, AcknowledgementSet acknowledgementSet, InputSerialization inputSerialization, BufferAccumulator<Record<Event>> bufferAccumulator) throws IOException {
        long objectSize = this.getObjectSize(s3ObjectReference);
        long startRange = 0L;
        long endRange = Math.min(0x4000000L, objectSize);
        while (startRange < objectSize) {
            ScanRange scanRange = (ScanRange)ScanRange.builder().start(Long.valueOf(startRange)).end(Long.valueOf(endRange)).build();
            SelectObjectContentRequest selectObjectContentRequest = this.getS3SelectObjRequest(s3ObjectReference, inputSerialization, scanRange);
            this.processSelectObjectRequest(selectObjectContentRequest, s3ObjectReference, acknowledgementSet, bufferAccumulator);
            startRange = endRange;
            endRange += Math.min(0x4000000L, objectSize - endRange);
        }
    }

    private Long getObjectSize(S3ObjectReference s3ObjectReference) {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(s3ObjectReference.getBucketName()).key(s3ObjectReference.getKey()).build();
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)this.s3AsyncClient.headObject(headObjectRequest).join();
        return headObjectResponse.contentLength();
    }

    private void processSelectObjectRequest(SelectObjectContentRequest selectObjectContentRequest, S3ObjectReference s3ObjectReference, AcknowledgementSet acknowledgementSet, BufferAccumulator<Record<Event>> bufferAccumulator) throws IOException {
        S3SelectResponseHandler s3SelectResponseHandler = this.s3SelectResponseHandlerFactory.provideS3SelectResponseHandler();
        this.s3AsyncClient.selectObjectContent(selectObjectContentRequest, (SelectObjectContentResponseHandler)s3SelectResponseHandler).join();
        if (s3SelectResponseHandler.getException() != null) {
            throw new IOException(s3SelectResponseHandler.getException());
        }
        List<SelectObjectContentEventStream> receivedEvents = s3SelectResponseHandler.getS3SelectContentEvents();
        if (!receivedEvents.isEmpty()) {
            InputStream inputStreamList = this.getInputStreamFromResponseHeader(s3SelectResponseHandler);
            this.parseCompleteStreamFromResponseHeader(acknowledgementSet, s3ObjectReference, bufferAccumulator, inputStreamList);
            this.s3ObjectPluginMetrics.getS3ObjectEventsSummary().record((double)bufferAccumulator.getTotalWritten());
            receivedEvents.clear();
        } else {
            LOG.info("S3 Select returned no events for S3 object {}", (Object)s3ObjectReference);
        }
    }

    private InputSerialization getInputSerializationFormat(S3SelectSerializationFormatOption serializationFormatOption) {
        InputSerialization inputSerialization = null;
        switch (serializationFormatOption) {
            case CSV: {
                inputSerialization = (InputSerialization)InputSerialization.builder().csv(csv -> csv.fileHeaderInfo(this.s3SelectCSVOption.getFileHeaderInfo()).quoteEscapeCharacter(this.s3SelectCSVOption.getQuiteEscape()).comments(this.s3SelectCSVOption.getComments()).allowQuotedRecordDelimiter(Boolean.valueOf(this.isQuotedRecordDelimiterAllowed())).build()).compressionType(this.compressionType).build();
                break;
            }
            case JSON: {
                inputSerialization = (InputSerialization)InputSerialization.builder().json(json -> json.type(this.s3SelectJsonOption.getType()).build()).compressionType(this.compressionType).build();
                break;
            }
            case PARQUET: {
                inputSerialization = (InputSerialization)InputSerialization.builder().parquet(p -> p.build()).compressionType(CompressionType.NONE).build();
            }
        }
        return inputSerialization;
    }

    private boolean isQuotedRecordDelimiterAllowed() {
        return this.s3SelectCSVOption.getQuiteEscape() != null || this.s3SelectCSVOption.getComments() != null;
    }

    private InputStream getInputStreamFromResponseHeader(S3SelectResponseHandler responseHand) {
        List inputStreams = responseHand.getS3SelectContentEvents().stream().filter(e -> e.sdkEventType() == SelectObjectContentEventStream.EventType.RECORDS).map(e -> ((RecordsEvent)e).payload().asInputStream()).collect(Collectors.toList());
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    private SelectObjectContentRequest getS3SelectObjRequest(S3ObjectReference s3ObjectReference, InputSerialization inputSerialization, ScanRange scanRange) {
        SelectObjectContentRequest.Builder selectObjectContentRequestBuilder = SelectObjectContentRequest.builder().bucket(s3ObjectReference.getBucketName()).key(s3ObjectReference.getKey()).expressionType(this.expressionType).expression(this.expression).inputSerialization(inputSerialization).outputSerialization(outputSerialization -> outputSerialization.json(SdkBuilder::build)).scanRange(scanRange);
        this.bucketOwnerProvider.getBucketOwner(s3ObjectReference.getBucketName()).ifPresent(arg_0 -> ((SelectObjectContentRequest.Builder)selectObjectContentRequestBuilder).expectedBucketOwner(arg_0));
        return (SelectObjectContentRequest)selectObjectContentRequestBuilder.build();
    }

    private void parseCompleteStreamFromResponseHeader(AcknowledgementSet acknowledgementSet, S3ObjectReference s3ObjectReference, BufferAccumulator<Record<Event>> bufferAccumulator, InputStream stream) throws IOException {
        block22: {
            try (CountingInputStream countingInputStream = new CountingInputStream(stream);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)countingInputStream);){
                BufferedReader reader = new BufferedReader(inputStreamReader);
                block19: while (true) {
                    Optional<String> selectObjectOptionalString;
                    while ((selectObjectOptionalString = Optional.ofNullable(reader.readLine())).isPresent()) {
                        Optional<JsonNode> optionalNode = this.addingS3Reference(s3ObjectReference, this.getJsonNode(selectObjectOptionalString.get()));
                        if (!optionalNode.isPresent()) continue;
                        Record eventRecord = new Record((Object)JacksonLog.builder().withData((Object)optionalNode.get()).build());
                        try {
                            this.eventConsumer.accept((Event)eventRecord.getData(), s3ObjectReference);
                            if (acknowledgementSet != null) {
                                acknowledgementSet.add((Event)eventRecord.getData());
                            }
                            bufferAccumulator.add(eventRecord);
                            continue block19;
                        }
                        catch (Exception ex) {
                            LOG.error("Failed writing S3 objects to buffer due to: {}", (Object)ex.getMessage());
                        }
                    }
                    break block22;
                    {
                        continue block19;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
        }
        try {
            bufferAccumulator.flush();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private JsonNode getJsonNode(String selectObjectOptionalString) throws JsonProcessingException {
        JsonNode recordJsonNode = this.serializationFormatOption.equals((Object)S3SelectSerializationFormatOption.CSV) && CSV_FILE_HEADER_INFO_NONE.equals(this.s3SelectCSVOption.getFileHeaderInfo()) ? this.csvColumNamesRefactorInCaseNoHeader(selectObjectOptionalString) : this.mapper.readTree(selectObjectOptionalString);
        return recordJsonNode;
    }

    private static ObjectNode getS3BucketObjectReference(S3ObjectReference s3ObjectReference, ObjectMapper mapper) {
        ObjectNode objNode = mapper.createObjectNode();
        objNode.put(S3_BUCKET_NAME, s3ObjectReference.getBucketName());
        objNode.put(S3_OBJECT_KEY, s3ObjectReference.getKey());
        return objNode;
    }

    private String generateColumnHeader(int columnNumber) {
        return "column" + columnNumber;
    }

    private JsonNode csvColumNamesRefactorInCaseNoHeader(String line) {
        HashMap<String, String> finalJson = new HashMap<String, String>();
        try {
            JsonParser jsonParser = this.jsonFactory.createParser(line);
            Map jsonObject = (Map)this.mapper.readValue(jsonParser, Map.class);
            for (int column = 0; column < jsonObject.size(); ++column) {
                finalJson.put(this.generateColumnHeader(column + 1), (String)jsonObject.get("_" + (column + 1)));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to refactor the columns names, Record - {}", (Object)line, (Object)e);
        }
        return this.mapper.valueToTree(finalJson);
    }

    private Optional<JsonNode> addingS3Reference(S3ObjectReference s3ObjectReference, JsonNode recordJsonNode) {
        try {
            JsonNode node = this.mapper.valueToTree((Object)recordJsonNode);
            ((ObjectNode)node).set(S3_BUCKET_REFERENCE_NAME, (JsonNode)S3SelectObjectWorker.getS3BucketObjectReference(s3ObjectReference, this.mapper));
            return Optional.of(node);
        }
        catch (Exception e) {
            LOG.error("Failed to append the S3 reference to the record. Bucket details - {}", (Object)recordJsonNode, (Object)e);
            return Optional.empty();
        }
    }
}

