/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.statistics;

import com.amazon.randomcutforest.parkservices.state.statistics.DeviationState;
import com.amazon.randomcutforest.parkservices.statistics.Deviation;
import com.amazon.randomcutforest.state.IStateMapper;

public class DeviationMapper
implements IStateMapper<Deviation, DeviationState> {
    public Deviation toModel(DeviationState state, long seed) {
        return new Deviation(state.getDiscount(), state.getWeight(), state.getSumSquared(), state.getSum(), state.getCount());
    }

    public DeviationState toState(Deviation model) {
        DeviationState state = new DeviationState();
        state.setDiscount(model.getDiscount());
        state.setSum(model.getSum());
        state.setSumSquared(model.getSumSquared());
        state.setWeight(model.getWeight());
        state.setCount(model.getCount());
        return state;
    }

    public static DeviationState[] getStates(Deviation[] list, DeviationMapper mapper) {
        DeviationState[] states = null;
        if (list != null) {
            states = new DeviationState[list.length];
            for (int i = 0; i < list.length; ++i) {
                states[i] = mapper.toState(list[i]);
            }
        }
        return states;
    }

    public static Deviation[] getDeviations(DeviationState[] states, DeviationMapper mapper) {
        Deviation[] deviations = null;
        if (states != null) {
            deviations = new Deviation[states.length];
            for (int i = 0; i < states.length; ++i) {
                deviations[i] = (Deviation)mapper.toModel(states[i]);
            }
        }
        return deviations;
    }
}

